/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.tag;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.supermartijn642.core.data.tag.CustomTagEntries;
import com.supermartijn642.core.data.tag.CustomTagEntry;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistry;

public class TagEntryAdapter
implements ITag.ITagEntry {
    final ResourceLocation identifier;
    final CustomTagEntry customEntry;
    private Registry<?> registry;
    private ForgeRegistry<?> forgeRegistry;

    TagEntryAdapter(ResourceLocation identifier, CustomTagEntry customEntry) {
        this.identifier = identifier;
        this.customEntry = customEntry;
    }

    public void setRegistry(Registry<?> registry, ForgeRegistry<?> forgeRegistry) {
        this.registry = registry;
        this.forgeRegistry = forgeRegistry;
    }

    public <T> boolean func_230238_a_(final Function<ResourceLocation, ITag<T>> tagLookup, final Function<ResourceLocation, T> elementLookup, Consumer<T> entryConsumer) {
        CustomTagEntry.TagEntryResolutionContext context = new CustomTagEntry.TagEntryResolutionContext<T>(){

            @Override
            public T getElement(ResourceLocation identifier) {
                return elementLookup.apply(identifier);
            }

            @Override
            public Collection<T> getTag(ResourceLocation identifier) {
                return ((ITag)tagLookup.apply(identifier)).func_230236_b_();
            }

            @Override
            public Collection<T> getAllElements() {
                return TagEntryAdapter.this.registry == null ? TagEntryAdapter.this.forgeRegistry.getValues() : (Collection)TagEntryAdapter.this.registry.func_201756_e().collect(Collectors.toList());
            }

            @Override
            public Set<ResourceLocation> getAllIdentifiers() {
                return TagEntryAdapter.this.registry == null ? TagEntryAdapter.this.forgeRegistry.getKeys() : TagEntryAdapter.this.registry.func_148742_b();
            }
        };
        Collection<T> entries = this.customEntry.resolve(context);
        if (entries != null) {
            entries.forEach(entryConsumer);
        }
        return true;
    }

    public String toString() {
        return "'" + this.identifier + "'{" + this.customEntry + "}";
    }

    public void func_230237_a_(JsonArray array) {
        array.add((JsonElement)CustomTagEntries.serialize(this));
    }
}

