/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class ConditionalRecipeSerializer
implements IRecipeSerializer<IRecipe<?>> {
    public static final ConditionalRecipeSerializer INSTANCE = new ConditionalRecipeSerializer();
    private ResourceLocation registryName;

    public static JsonObject wrapRecipeWithForgeConditions(JsonObject recipe, Collection<ICondition> conditions) {
        JsonObject json = new JsonObject();
        json.addProperty("type", Registries.RECIPE_SERIALIZERS.getIdentifier(INSTANCE).toString());
        JsonArray conditionsJson = new JsonArray();
        for (ICondition condition : conditions) {
            conditionsJson.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
        }
        json.add("conditions", (JsonElement)conditionsJson);
        json.add("recipe", (JsonElement)recipe);
        return json;
    }

    public static JsonObject wrapRecipe(JsonObject recipe, Collection<ResourceCondition> conditions) {
        return ConditionalRecipeSerializer.wrapRecipeWithForgeConditions(recipe, conditions.stream().map(ResourceCondition::createForgeCondition).collect(Collectors.toList()));
    }

    private ConditionalRecipeSerializer() {
    }

    public IRecipe<?> func_199425_a_(ResourceLocation location, JsonObject json) {
        if (!json.has("conditions") || !json.get("conditions").isJsonArray()) {
            throw new RuntimeException("Conditional recipe '" + location + "' must have 'conditions' array!");
        }
        if (!json.has("recipe") || !json.get("recipe").isJsonObject()) {
            throw new RuntimeException("Conditional recipe '" + location + "' must have 'recipe' object!");
        }
        JsonArray conditions = json.getAsJsonArray("conditions");
        for (JsonElement conditionElement : conditions) {
            ICondition condition;
            if (!conditionElement.isJsonObject()) {
                throw new RuntimeException("Conditions array for recipe '" + location + "' must only contain objects!");
            }
            JsonObject conditionJson = conditionElement.getAsJsonObject();
            if (!(conditionJson.has("type") && conditionJson.get("type").isJsonPrimitive() && conditionJson.get("type").getAsJsonPrimitive().isString())) {
                throw new RuntimeException("Condition for recipe '" + location + "' is missing 'type' key!");
            }
            String type = conditionJson.get("type").getAsString();
            if (!RegistryUtil.isValidIdentifier(type)) {
                throw new RuntimeException("Condition for recipe '" + location + "' has invalid type '" + type + "'!");
            }
            IConditionSerializer<?> serializer = Registries.RECIPE_CONDITION_SERIALIZERS.getValue(new ResourceLocation(type));
            if (serializer == null) {
                throw new RuntimeException("Condition for recipe '" + location + "' has unknown type '" + new ResourceLocation(type) + "'!");
            }
            try {
                condition = serializer.read(conditionJson);
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered exception whilst testing condition '" + new ResourceLocation(type) + "' for recipe '" + location + "'!");
            }
            if (condition.test()) continue;
            return null;
        }
        return RecipeManager.func_215377_a((ResourceLocation)location, (JsonObject)json.getAsJsonObject("recipe"));
    }

    public IRecipe<?> func_199426_a_(ResourceLocation resourceLocation, PacketBuffer friendlyByteBuf) {
        return null;
    }

    public void func_199427_a_(PacketBuffer friendlyByteBuf, IRecipe<?> recipe) {
    }

    public IRecipeSerializer<?> setRegistryName(ResourceLocation name) {
        this.registryName = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public Class<IRecipeSerializer<?>> getRegistryType() {
        return ForgeRegistries.RECIPE_SERIALIZERS.getRegistrySuperType();
    }
}

