/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.condition;

import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;

public class TagPopulatedResourceCondition
implements ResourceCondition {
    public static final Map<Registries.Registry<?>, Supplier<ITagCollection<?>>> TAGS = new HashMap();
    public static final Serializer SERIALIZER;
    private final Registries.Registry<?> registry;
    private final ResourceLocation tag;

    public TagPopulatedResourceCondition(Registries.Registry<?> registry, ResourceLocation tag) {
        if (!TAGS.containsKey(registry)) {
            throw new IllegalArgumentException("Registry '" + registry.getRegistryIdentifier() + "' is not supported!");
        }
        this.registry = registry;
        this.tag = tag;
    }

    @Override
    public boolean test(ResourceConditionContext context) {
        return TAGS.get(this.registry).get().func_241834_b(this.tag).func_230236_b_().isEmpty();
    }

    @Override
    public ResourceConditionSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    static {
        TAGS.put(Registries.ITEMS, ItemTags::func_199903_a);
        TAGS.put(Registries.BLOCKS, BlockTags::func_199896_a);
        TAGS.put(Registries.ENTITY_TYPES, EntityTypeTags::func_219762_a);
        TAGS.put(Registries.FLUIDS, FluidTags::func_226157_a_);
        SERIALIZER = new Serializer();
    }

    private static class Serializer
    implements ResourceConditionSerializer<TagPopulatedResourceCondition> {
        private Serializer() {
        }

        @Override
        public void serialize(JsonObject json, TagPopulatedResourceCondition condition) {
            json.addProperty("registry", condition.registry.getRegistryIdentifier().toString());
            json.addProperty("tag", condition.tag.toString());
        }

        @Override
        public TagPopulatedResourceCondition deserialize(JsonObject json) {
            if (!(json.has("registry") && json.get("registry").isJsonPrimitive() && json.getAsJsonPrimitive("registry").isString())) {
                throw new RuntimeException("Condition must have key 'registry' of type string!");
            }
            if (!(json.has("tag") && json.get("tag").isJsonPrimitive() && json.getAsJsonPrimitive("tag").isString())) {
                throw new RuntimeException("Condition must have key 'tag' of type string!");
            }
            if (!RegistryUtil.isValidIdentifier(json.get("registry").getAsString())) {
                throw new RuntimeException("Value for 'registry' must be a valid identifier!");
            }
            if (!RegistryUtil.isValidIdentifier(json.get("tag").getAsString())) {
                throw new RuntimeException("Value for 'tag' must be a valid identifier!");
            }
            Registries.Registry<?> registry = Registries.getRegistry(new ResourceLocation(json.get("registry").getAsString()));
            if (registry == null) {
                throw new RuntimeException("Could not find a registry with identifier '" + json.get("registry").getAsString() + "'!");
            }
            ResourceLocation tag = new ResourceLocation(json.get("tag").getAsString());
            return new TagPopulatedResourceCondition(registry, tag);
        }
    }
}

