/*
 * Decompiled with CFR 0.152.
 */
package com.blukzen.createlab.world;

import com.blukzen.createlab.CreateLab;
import com.blukzen.createlab.data.ILaboratory;
import com.blukzen.createlab.data.LaboratoryCapability;
import com.blukzen.createlab.dimension.LabDimensions;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class LabTeleporter
implements ITeleporter {
    private final BlockPos spawn = new BlockPos(0, 64, 0);

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerWorld dest, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
        CreateLab.LOGGER.info("Teleporting " + entity.func_145748_c_() + " to " + dest.func_234923_W_().getRegistryName().func_110623_a());
        if (dest.func_234923_W_() == LabDimensions.LABDIM) {
            if (entity instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                entity.getCapability(LaboratoryCapability.LABORATORY_CAPABILITY).ifPresent(lab -> {
                    lab.savePlayerData(player);
                    lab.resetPlayer(player);
                    player.func_71033_a(GameType.CREATIVE);
                });
            }
            return new PortalInfo(Vector3d.func_237489_a_((Vector3i)this.spawn), Vector3d.field_186680_a, entity.field_70177_z, entity.field_70125_A);
        }
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            ILaboratory lab2 = (ILaboratory)entity.getCapability(LaboratoryCapability.LABORATORY_CAPABILITY).orElseThrow(RuntimeException::new);
            lab2.resetPlayer(player);
            lab2.restorePlayerData(player);
            return new PortalInfo(Vector3d.func_237489_a_((Vector3i)lab2.getPosition()), Vector3d.field_186680_a, entity.field_70177_z, entity.field_70125_A);
        }
        return new PortalInfo(Vector3d.func_237489_a_((Vector3i)this.spawn), Vector3d.field_186680_a, entity.field_70177_z, entity.field_70125_A);
    }
}

