/*
 * Decompiled with CFR 0.152.
 */
package com.blukzen.createlab.world;

import com.blukzen.createlab.CreateLabConfig;
import com.blukzen.createlab.block.LabBlocks;
import com.blukzen.createlab.block.LabPortalBlock;
import com.blukzen.createlab.util.GUIUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class LabPortal {
    private static final AbstractBlock.IPositionPredicate FRAME = (blockState, blockReader, blockPos) -> ((List)CreateLabConfig.labPortalFrameBlocks.get()).contains(blockState.func_177230_c().getRegistryName().toString());
    private final IWorld level;
    private final Direction.Axis axis;
    private final Direction rightDir;
    private int numPortalBlocks;
    @Nullable
    private BlockPos bottomLeft;
    private int height;
    private int width;

    public static Optional<LabPortal> findEmptyPortalShape(IWorld world, BlockPos blockPos, Direction.Axis axis) {
        return LabPortal.findPortalShape(world, blockPos, labPortal -> labPortal.isValid() && labPortal.numPortalBlocks == 0, axis);
    }

    public static Optional<LabPortal> findPortalShape(IWorld world, BlockPos blockPos, Predicate<LabPortal> labPortalPredicate, Direction.Axis axis) {
        Optional<LabPortal> optional = Optional.of(new LabPortal(world, blockPos, axis)).filter(labPortalPredicate);
        if (optional.isPresent()) {
            return optional;
        }
        Direction.Axis direction$axis = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return Optional.of(new LabPortal(world, blockPos, direction$axis)).filter(labPortalPredicate);
    }

    public LabPortal(IWorld level, BlockPos blockPos, Direction.Axis axis) {
        this.level = level;
        this.axis = axis;
        this.rightDir = axis == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
        this.bottomLeft = this.calculateBottomLeft(blockPos);
        if (this.bottomLeft == null) {
            this.bottomLeft = blockPos;
            this.width = 1;
            this.height = 1;
        } else {
            this.width = this.calculateWidth();
            if (this.width > 0) {
                this.height = this.calculateHeight();
            }
        }
        if (FMLEnvironment.dist.isClient()) {
            GUIUtil gui = GUIUtil.INSTANCE;
            gui.addDebugMessage("Portal Width", String.valueOf(this.width));
            gui.addDebugMessage("Portal Height", String.valueOf(this.height));
            gui.addDebugMessage("Portal Axis", this.axis.func_176719_a());
            gui.addDebugMessage("Portal Right", this.rightDir.func_176742_j());
            gui.addDebugMessage("Portal Bottom Left", this.bottomLeft.toString());
        }
    }

    @Nullable
    private BlockPos calculateBottomLeft(BlockPos pos) {
        int i = Math.max(0, pos.func_177956_o() - 21);
        while (pos.func_177956_o() > i && LabPortal.isEmpty(this.level.func_180495_p(pos.func_177977_b()))) {
            pos = pos.func_177977_b();
        }
        Direction direction = this.rightDir.func_176734_d();
        int j = this.getDistanceUntilEdgeAboveFrame(pos, direction) - 1;
        return j < 0 ? null : pos.func_177967_a(direction, j);
    }

    private int calculateWidth() {
        int i = this.getDistanceUntilEdgeAboveFrame(this.bottomLeft, this.rightDir);
        return i >= 2 && i <= 21 ? i : 0;
    }

    private int getDistanceUntilEdgeAboveFrame(BlockPos blockPos, Direction direction) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = 0; i <= 21; ++i) {
            blockpos$mutable.func_189533_g((Vector3i)blockPos).func_189534_c(direction, i);
            BlockState blockstate = this.level.func_180495_p((BlockPos)blockpos$mutable);
            if (!LabPortal.isEmpty(blockstate)) {
                if (!FRAME.test(blockstate, (IBlockReader)this.level, (BlockPos)blockpos$mutable)) break;
                return i;
            }
            BlockState blockstate1 = this.level.func_180495_p((BlockPos)blockpos$mutable.func_189536_c(Direction.DOWN));
            if (!FRAME.test(blockstate1, (IBlockReader)this.level, (BlockPos)blockpos$mutable)) break;
        }
        return 0;
    }

    private int calculateHeight() {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int i = this.getDistanceUntilTop(blockpos$mutable);
        return i >= 3 && i <= 21 && this.hasTopFrame(blockpos$mutable, i) ? i : 0;
    }

    private boolean hasTopFrame(BlockPos.Mutable blockPos, int p_242970_2_) {
        for (int i = 0; i < this.width; ++i) {
            BlockPos.Mutable blockpos$mutable = blockPos.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, p_242970_2_).func_189534_c(this.rightDir, i);
            if (FRAME.test(this.level.func_180495_p((BlockPos)blockpos$mutable), (IBlockReader)this.level, (BlockPos)blockpos$mutable)) continue;
            return false;
        }
        return true;
    }

    private int getDistanceUntilTop(BlockPos.Mutable blockPos) {
        for (int i = 0; i < 21; ++i) {
            blockPos.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, i).func_189534_c(this.rightDir, -1);
            if (!FRAME.test(this.level.func_180495_p((BlockPos)blockPos), (IBlockReader)this.level, (BlockPos)blockPos)) {
                return i;
            }
            blockPos.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, i).func_189534_c(this.rightDir, this.width);
            if (!FRAME.test(this.level.func_180495_p((BlockPos)blockPos), (IBlockReader)this.level, (BlockPos)blockPos)) {
                return i;
            }
            for (int j = 0; j < this.width; ++j) {
                blockPos.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, i).func_189534_c(this.rightDir, j);
                BlockState blockstate = this.level.func_180495_p((BlockPos)blockPos);
                if (!LabPortal.isEmpty(blockstate)) {
                    return i;
                }
                if (!blockstate.func_203425_a((Block)LabBlocks.LAB_PORTAL.get())) continue;
                ++this.numPortalBlocks;
            }
        }
        return 21;
    }

    private static boolean isEmpty(BlockState blockState) {
        return blockState.func_196958_f() || blockState.func_235714_a_((ITag)BlockTags.field_232872_am_) || blockState.func_203425_a((Block)LabBlocks.LAB_PORTAL.get());
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void createPortalBlocks() {
        BlockState blockstate = (BlockState)((Block)LabBlocks.LAB_PORTAL.get()).func_176223_P().func_206870_a(LabPortalBlock.AXIS, (Comparable)this.axis);
        BlockPos.func_218278_a((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.func_177967_a(Direction.UP, this.height - 1).func_177967_a(this.rightDir, this.width - 1)).forEach(blockPos -> this.level.func_180501_a(blockPos, blockstate, 18));
    }

    public boolean isComplete() {
        return this.isValid() && this.numPortalBlocks == this.width * this.height;
    }
}

