/*
 * Decompiled with CFR 0.152.
 */
package com.blukzen.createlab.network;

import com.blukzen.createlab.data.ILaboratory;
import com.blukzen.createlab.data.LaboratoryProvider;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncLaboratory {
    private int entityId;
    private CompoundNBT laboratory;

    public PacketSyncLaboratory(int entityId, ILaboratory laboratory) {
        this.entityId = entityId;
        this.laboratory = (CompoundNBT)laboratory.serializeNBT();
    }

    public PacketSyncLaboratory(int entityId, CompoundNBT laboratory) {
        this.entityId = entityId;
        this.laboratory = laboratory;
    }

    public static void encode(PacketSyncLaboratory msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.func_150786_a(msg.laboratory);
    }

    public static PacketSyncLaboratory decode(PacketBuffer buf) {
        int entityId = buf.readInt();
        CompoundNBT laboratory = buf.func_150793_b();
        return new PacketSyncLaboratory(entityId, laboratory);
    }

    public static void handle(PacketSyncLaboratory msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && (entity = world.func_73045_a(msg.entityId)) instanceof PlayerEntity) {
                LaboratoryProvider.getHandler((PlayerEntity)entity).ifPresent(handler -> handler.deserializeNBT((INBT)msg.laboratory));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

