/*
 * Decompiled with CFR 0.152.
 */
package com.blukzen.createlab.mixin;

import com.blukzen.createlab.accessor.EntityAccessor;
import com.blukzen.createlab.dimension.LabDimensions;
import com.blukzen.createlab.world.LabTeleporter;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.INameable;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.extensions.IForgeEntity;
import net.minecraftforge.common.util.ITeleporter;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin
extends CapabilityProvider<Entity>
implements INameable,
ICommandSource,
IForgeEntity,
EntityAccessor {
    @Unique
    protected boolean insideLabPortal;
    @Unique
    protected float labPortalTime = 0.0f;
    @Unique
    private float labPortalCooldown = 0.0f;
    @Unique
    private final float labPortalWaittime = 50.0f;
    @Shadow
    public World field_70170_p;
    @Shadow
    @Final
    protected Random field_70146_Z;

    @Override
    public float getLabPortalTime() {
        return this.labPortalTime;
    }

    protected EntityMixin(Class<Entity> baseClass) {
        super(baseClass);
    }

    @Shadow
    public abstract boolean func_184218_aH();

    @Shadow
    @Nullable
    public abstract Entity changeDimension(ServerWorld var1, ITeleporter var2);

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    public void baseTick(CallbackInfo ci) {
        this.handleLabPortal();
    }

    @Override
    public void handleInsideLabPortal() {
        if (this.isOnLabPortalCooldown()) {
            this.setLabPortalCooldown();
        } else {
            this.insideLabPortal = true;
        }
    }

    @Override
    public void handleLabPortal() {
        if (this.field_70170_p instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
            if (this.insideLabPortal) {
                RegistryKey<World> registryKey;
                MinecraftServer server = serverWorld.func_73046_m();
                ServerWorld destinationWorld = server.func_71218_a(registryKey = this.field_70170_p.func_234923_W_() == LabDimensions.LABDIM ? World.field_234918_g_ : LabDimensions.LABDIM);
                if (destinationWorld != null && !this.func_184218_aH()) {
                    float f = this.labPortalTime;
                    this.labPortalTime = f + 1.0f;
                    if (f >= this.labPortalWaittime) {
                        this.field_70170_p.func_217381_Z().func_76320_a("portal");
                        this.labPortalTime = 0.0f;
                        this.setLabPortalCooldown();
                        this.changeDimension(destinationWorld, new LabTeleporter());
                        this.field_70170_p.func_217381_Z().func_76319_b();
                    }
                }
            } else if (this.labPortalTime > 0.0f) {
                this.labPortalTime -= 1.0f;
            }
            this.insideLabPortal = false;
            this.processLabPortalCooldown();
        }
    }

    @Override
    public boolean isInsideLabPortal() {
        return this.insideLabPortal;
    }

    @Override
    public boolean isOnLabPortalCooldown() {
        return this.labPortalCooldown > 0.0f;
    }

    @Override
    public void setLabPortalCooldown() {
        this.labPortalCooldown = 20.0f;
    }

    @Override
    public float getLabPortalCooldown() {
        return this.labPortalCooldown;
    }

    protected void processLabPortalCooldown() {
        if (this.isOnLabPortalCooldown()) {
            this.labPortalCooldown -= 1.0f;
        }
    }
}

