/*
 * Decompiled with CFR 0.152.
 */
package com.blukzen.createlab.integration.curios;

import com.blukzen.createlab.data.Laboratory;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class LaboratoryCurios
extends Laboratory {
    ListNBT curios = new ListNBT();

    @Override
    public void savePlayerData(ServerPlayerEntity player) {
        super.savePlayerData(player);
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
            this.curios = this.curiosToNBT(handler.getCurios());
        });
    }

    @Override
    public void restorePlayerData(ServerPlayerEntity player) {
        super.restorePlayerData(player);
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
            for (int i = 0; i < this.curios.size(); ++i) {
                CompoundNBT tag = this.curios.func_150305_b(i);
                String identifier = tag.func_74779_i("slot");
                handler.getStacksHandler(identifier).ifPresent(stacksHandler -> stacksHandler.deserializeNBT(tag.func_74775_l("curiosStack")));
            }
        });
    }

    @Override
    public void resetPlayer(ServerPlayerEntity player) {
        super.resetPlayer(player);
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(ICuriosItemHandler::reset);
    }

    @Override
    public INBT serializeNBT() {
        CompoundNBT tag = (CompoundNBT)super.serializeNBT();
        tag.func_218657_a("curios", (INBT)this.curios);
        return tag;
    }

    @Override
    public void deserializeNBT(INBT nbt) {
        CompoundNBT tag = (CompoundNBT)nbt;
        super.deserializeNBT((INBT)tag);
        this.curios = tag.func_150295_c("curios", 10);
    }

    @Override
    public IFormattableTextComponent toText() {
        IFormattableTextComponent component = super.toText();
        component.func_240702_b_(TextFormatting.AQUA + "Curios: " + TextFormatting.RESET + "\n" + this.curios.toString() + "\n");
        return component;
    }

    private ListNBT curiosToNBT(Map<String, ICurioStacksHandler> curios) {
        ListNBT tagList = new ListNBT();
        curios.forEach((slot, stacksHandler) -> {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("slot", slot);
            tag.func_218657_a("curiosStack", (INBT)stacksHandler.serializeNBT());
            tagList.add((Object)tag);
        });
        return tagList;
    }
}

