/*
 * Decompiled with CFR 0.152.
 */
package com.blukzen.createlab.data;

import com.blukzen.createlab.data.ILaboratory;
import com.blukzen.createlab.data.Laboratory;
import com.blukzen.createlab.data.LaboratoryCapability;
import com.blukzen.createlab.integration.curios.LaboratoryCurios;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;

public class LaboratoryProvider
implements ICapabilitySerializable<INBT> {
    private final ILaboratory handler = ModList.get().isLoaded("curios") ? new LaboratoryCurios() : new Laboratory();
    private final LazyOptional<ILaboratory> optional = LazyOptional.of(() -> this.handler);

    public LaboratoryProvider(PlayerEntity player) {
    }

    public static LazyOptional<ILaboratory> getHandler(PlayerEntity player) {
        return player.getCapability(LaboratoryCapability.LABORATORY_CAPABILITY);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return LaboratoryCapability.LABORATORY_CAPABILITY.orEmpty(cap, this.optional);
    }

    public INBT serializeNBT() {
        return LaboratoryCapability.LABORATORY_CAPABILITY.writeNBT((Object)this.handler, null);
    }

    public void deserializeNBT(INBT nbt) {
        LaboratoryCapability.LABORATORY_CAPABILITY.readNBT((Object)this.handler, null, nbt);
    }
}

