/*
 * Decompiled with CFR 0.152.
 */
package com.blukzen.createlab.data;

import com.blukzen.createlab.data.ILaboratory;
import com.blukzen.createlab.util.NBTHelpers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;

public class Laboratory
implements ILaboratory {
    public static String INVENTORY_KEY = "inventory";
    public static String POSITION_KEY = "position";
    public static String GAMEMODE_KEY = "gamemode";
    GameType gamemode = GameType.NOT_SET;
    BlockPos position = BlockPos.field_177992_a;
    ListNBT armor = new ListNBT();
    ListNBT items = new ListNBT();
    ListNBT offhand = new ListNBT();
    int experienceLevels;
    float experienceProgress;

    @Override
    public void savePlayerData(ServerPlayerEntity player) {
        this.saveInventory(player.field_71071_by);
        this.savePosition(player.func_233580_cy_());
        this.saveGamemode(player.field_71134_c.func_73081_b());
        this.experienceLevels = player.field_71068_ca;
        this.experienceProgress = player.field_71106_cc;
    }

    @Override
    public void restorePlayerData(ServerPlayerEntity player) {
        this.restoreInventory(player.field_71071_by);
        player.func_71033_a(this.gamemode);
        player.field_71068_ca = this.experienceLevels;
        player.field_71106_cc = this.experienceProgress;
    }

    @Override
    public void resetPlayer(ServerPlayerEntity player) {
        player.field_71071_by.func_174888_l();
        player.func_195399_b(0);
        player.func_195394_a(0);
    }

    @Override
    public GameType getGamemode() {
        return this.gamemode;
    }

    @Override
    public void saveGamemode(GameType gamemode) {
        if (gamemode == null) {
            return;
        }
        this.gamemode = gamemode;
    }

    @Override
    public BlockPos getPosition() {
        return this.position;
    }

    @Override
    public void savePosition(BlockPos position) {
        this.position = position;
    }

    @Override
    public void saveInventory(PlayerInventory inventory) {
        if (inventory == null) {
            return;
        }
        this.armor = NBTHelpers.itemStackToNBT((List<ItemStack>)inventory.field_70460_b);
        this.items = NBTHelpers.itemStackToNBT((List<ItemStack>)inventory.field_70462_a);
        this.offhand = NBTHelpers.itemStackToNBT((List<ItemStack>)inventory.field_184439_c);
    }

    @Override
    public void restoreInventory(PlayerInventory inventory) {
        if (inventory == null) {
            return;
        }
        this.replaceInventory((NonNullList<ItemStack>)inventory.field_70462_a, this.getSavedItems());
        this.replaceInventory((NonNullList<ItemStack>)inventory.field_70460_b, this.getSavedArmor());
        this.replaceInventory((NonNullList<ItemStack>)inventory.field_184439_c, this.getSavedOffHand());
    }

    private void replaceInventory(NonNullList<ItemStack> inventory, List<ItemStack> items) {
        for (int i = 0; i < items.size(); ++i) {
            inventory.set(i, (Object)items.get(i));
        }
    }

    @Override
    public List<ItemStack> getSavedArmor() {
        if (this.armor == null) {
            return new ArrayList<ItemStack>();
        }
        return NBTHelpers.itemStackFromNBT(this.armor);
    }

    @Override
    public ListNBT getSavedArmorNBT() {
        return this.armor;
    }

    @Override
    public void setSavedArmor(NonNullList<ItemStack> armor) {
        this.armor = NBTHelpers.itemStackToNBT(armor);
    }

    @Override
    public void setSavedArmor(ListNBT armor) {
        this.armor = armor;
    }

    @Override
    public List<ItemStack> getSavedItems() {
        if (this.items == null) {
            return new ArrayList<ItemStack>();
        }
        return NBTHelpers.itemStackFromNBT(this.items);
    }

    @Override
    public ListNBT getSavedItemsNBT() {
        return this.items;
    }

    @Override
    public void setSavedItems(NonNullList<ItemStack> items) {
        this.items = NBTHelpers.itemStackToNBT(items);
    }

    @Override
    public void setSavedItems(ListNBT items) {
        this.items = items;
    }

    @Override
    public List<ItemStack> getSavedOffHand() {
        if (this.armor == null) {
            return new ArrayList<ItemStack>();
        }
        return NBTHelpers.itemStackFromNBT(this.offhand);
    }

    @Override
    public ListNBT getSavedOffHandNBT() {
        return this.offhand;
    }

    @Override
    public void setSavedOffHand(NonNullList<ItemStack> offhand) {
        this.offhand = NBTHelpers.itemStackToNBT(offhand);
    }

    @Override
    public void setSavedOffHand(ListNBT offhand) {
        this.offhand = offhand;
    }

    @Override
    public INBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        CompoundNBT inventoryTag = new CompoundNBT();
        inventoryTag.func_218657_a("items", (INBT)this.items);
        inventoryTag.func_218657_a("armor", (INBT)this.armor);
        inventoryTag.func_218657_a("offhand", (INBT)this.offhand);
        tag.func_218657_a(INVENTORY_KEY, (INBT)inventoryTag);
        tag.func_218657_a(POSITION_KEY, (INBT)NBTUtil.func_186859_a((BlockPos)this.getPosition()));
        tag.func_74768_a(GAMEMODE_KEY, this.gamemode.func_77148_a());
        return tag;
    }

    @Override
    public void deserializeNBT(INBT nbt) {
        CompoundNBT tag = (CompoundNBT)nbt;
        CompoundNBT inventoryTag = tag.func_74775_l(INVENTORY_KEY);
        CompoundNBT positionTag = tag.func_74775_l(POSITION_KEY);
        ListNBT itemsNBT = inventoryTag.func_150295_c("items", 10);
        ListNBT armorNBT = inventoryTag.func_150295_c("armor", 10);
        ListNBT offhandNBT = inventoryTag.func_150295_c("offhand", 10);
        this.setSavedItems(itemsNBT);
        this.setSavedArmor(armorNBT);
        this.setSavedOffHand(offhandNBT);
        this.savePosition(NBTUtil.func_186861_c((CompoundNBT)positionTag));
        this.saveGamemode(GameType.func_77146_a((int)tag.func_74762_e(GAMEMODE_KEY)));
    }

    @Override
    public IFormattableTextComponent toText() {
        StringTextComponent component = new StringTextComponent("");
        component.func_240702_b_(TextFormatting.AQUA + "Gamemode: " + TextFormatting.RESET + this.gamemode + "\n");
        component.func_240702_b_(TextFormatting.AQUA + "Position: " + TextFormatting.RESET + this.position.toString() + "\n");
        component.func_240702_b_(TextFormatting.AQUA + "Items: " + TextFormatting.RESET + "\n" + this.items.toString() + "\n");
        component.func_240702_b_(TextFormatting.AQUA + "Armor: " + TextFormatting.RESET + "\n" + this.armor.toString() + "\n");
        component.func_240702_b_(TextFormatting.AQUA + "Offhand: " + TextFormatting.RESET + "\n" + this.offhand.toString() + "\n");
        return component;
    }
}

