/*
 * Decompiled with CFR 0.152.
 */
package com.blukzen.createlab.commands;

import com.blukzen.createlab.CreateLabConfig;
import com.blukzen.createlab.data.LaboratoryCapability;
import com.blukzen.createlab.dimension.LabDimensions;
import com.blukzen.createlab.util.TeleportationTools;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CommandTeleport
implements Command<CommandSource> {
    private static final CommandTeleport CMD = new CommandTeleport();

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"tp").requires(cs -> cs.func_197034_c(((Integer)CreateLabConfig.tpCommandPermissionLevel.get()).intValue()))).executes((Command)CMD);
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        if (player.func_130014_f_().func_234923_W_().equals(LabDimensions.LABDIM)) {
            ServerWorld world = player.func_184102_h().func_71218_a(World.field_234918_g_);
            player.getCapability(LaboratoryCapability.LABORATORY_CAPABILITY).ifPresent(lab -> {
                lab.resetPlayer(player);
                lab.restorePlayerData(player);
                TeleportationTools.teleport(player, world, lab.getPosition());
            });
        } else {
            ServerWorld world = player.func_184102_h().func_71218_a(LabDimensions.LABDIM);
            player.getCapability(LaboratoryCapability.LABORATORY_CAPABILITY).ifPresent(lab -> {
                lab.savePlayerData(player);
                lab.resetPlayer(player);
                player.func_71033_a(GameType.CREATIVE);
                TeleportationTools.teleport(player, world, new BlockPos(0, 65, 0));
            });
        }
        return 0;
    }
}

