/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.connecting;

import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import com.supermartijn642.fusion.model.types.connecting.SurroundingBlockData;
import java.util.function.Function;

public class ConnectingTextureLayoutHelper {
    private static final LayoutProperties[] LAYOUT_TO_PROPERTIES = new LayoutProperties[]{LayoutProperties.FULL, LayoutProperties.HORIZONTAL, LayoutProperties.SIMPLE, LayoutProperties.VERTICAL, LayoutProperties.COMPACT};

    public static int getWidth(ConnectingTextureLayout layout) {
        return ConnectingTextureLayoutHelper.LAYOUT_TO_PROPERTIES[layout.ordinal()].width;
    }

    public static int getHeight(ConnectingTextureLayout layout) {
        return ConnectingTextureLayoutHelper.LAYOUT_TO_PROPERTIES[layout.ordinal()].height;
    }

    public static int[] getStatePosition(ConnectingTextureLayout layout, SurroundingBlockData.SideConnections connections) {
        return ConnectingTextureLayoutHelper.LAYOUT_TO_PROPERTIES[layout.ordinal()].tilePicker.apply(connections);
    }

    private static enum LayoutProperties {
        FULL(8, 8, connections -> {
            int[] uv = !(connections.left || connections.top || connections.right || connections.bottom) ? new int[]{0, 0} : (connections.left && !connections.top && !connections.right && !connections.bottom ? new int[]{3, 0} : (!connections.left && connections.top && !connections.right && !connections.bottom ? new int[]{0, 3} : (!connections.left && !connections.top && connections.right && !connections.bottom ? new int[]{1, 0} : (!connections.left && !connections.top && !connections.right && connections.bottom ? new int[]{0, 1} : (connections.left && !connections.top && connections.right && !connections.bottom ? new int[]{2, 0} : (!connections.left && connections.top && !connections.right && connections.bottom ? new int[]{0, 2} : (connections.left && connections.top && !connections.right && !connections.bottom ? (connections.topLeft ? new int[]{3, 3} : new int[]{5, 1}) : (!connections.left && connections.top && connections.right && !connections.bottom ? (connections.topRight ? new int[]{1, 3} : new int[]{4, 1}) : (!connections.left && !connections.top && connections.right && connections.bottom ? (connections.bottomRight ? new int[]{1, 1} : new int[]{4, 0}) : (connections.left && !connections.top && !connections.right && connections.bottom ? (connections.bottomLeft ? new int[]{3, 1} : new int[]{5, 0}) : (!connections.left ? (connections.topRight && connections.bottomRight ? new int[]{1, 2} : (connections.topRight ? new int[]{4, 2} : (connections.bottomRight ? new int[]{6, 2} : new int[]{6, 0}))) : (!connections.top ? (connections.bottomLeft && connections.bottomRight ? new int[]{2, 1} : (connections.bottomLeft ? new int[]{7, 2} : (connections.bottomRight ? new int[]{5, 2} : new int[]{7, 0}))) : (!connections.right ? (connections.topLeft && connections.bottomLeft ? new int[]{3, 2} : (connections.topLeft ? new int[]{7, 3} : (connections.bottomLeft ? new int[]{5, 3} : new int[]{7, 1}))) : (!connections.bottom ? (connections.topLeft && connections.topRight ? new int[]{2, 3} : (connections.topLeft ? new int[]{4, 3} : (connections.topRight ? new int[]{6, 3} : new int[]{6, 1}))) : (connections.topLeft && connections.topRight && connections.bottomLeft && connections.bottomRight ? new int[]{2, 2} : (!connections.topLeft && connections.topRight && connections.bottomLeft && connections.bottomRight ? new int[]{7, 5} : (connections.topLeft && !connections.topRight && connections.bottomLeft && connections.bottomRight ? new int[]{6, 5} : (connections.topLeft && connections.topRight && !connections.bottomLeft && connections.bottomRight ? new int[]{7, 4} : (connections.topLeft && connections.topRight && connections.bottomLeft && !connections.bottomRight ? new int[]{6, 4} : (!connections.topLeft && connections.topRight && !connections.bottomRight && connections.bottomLeft ? new int[]{0, 4} : (connections.topLeft && !connections.topRight && connections.bottomRight && !connections.bottomLeft ? new int[]{0, 5} : (!connections.topLeft && !connections.topRight && connections.bottomRight && connections.bottomLeft ? new int[]{3, 4} : (connections.topLeft && !connections.topRight && !connections.bottomRight && connections.bottomLeft ? new int[]{3, 5} : (connections.topLeft && connections.topRight && !connections.bottomRight && !connections.bottomLeft ? new int[]{2, 5} : (!connections.topLeft && connections.topRight && connections.bottomRight && !connections.bottomLeft ? new int[]{2, 4} : (connections.topLeft ? new int[]{5, 5} : (connections.topRight ? new int[]{4, 5} : (connections.bottomRight ? new int[]{4, 4} : (connections.bottomLeft ? new int[]{5, 4} : new int[]{1, 4})))))))))))))))))))))))))))));
            return uv;
        }),
        HORIZONTAL(4, 1, connections -> {
            int[] uv = connections.left && connections.right ? new int[]{2, 0} : (connections.left ? new int[]{3, 0} : (connections.right ? new int[]{1, 0} : new int[]{0, 0}));
            return uv;
        }),
        SIMPLE(4, 4, connections -> {
            int[] uv = !connections.left && !connections.top && !connections.right && !connections.bottom ? new int[]{0, 0} : (connections.left && !connections.top && !connections.right && !connections.bottom ? new int[]{3, 0} : (!connections.left && connections.top && !connections.right && !connections.bottom ? new int[]{3, 1} : (!connections.left && !connections.top && connections.right && !connections.bottom ? new int[]{2, 1} : (!connections.left && !connections.top && !connections.right && connections.bottom ? new int[]{2, 0} : (connections.left && !connections.top && connections.right && !connections.bottom ? new int[]{0, 1} : (!connections.left && connections.top && !connections.right && connections.bottom ? new int[]{1, 1} : (connections.left && connections.top && !connections.right && !connections.bottom ? new int[]{3, 3} : (!connections.left && connections.top && connections.right && !connections.bottom ? new int[]{2, 3} : (!connections.left && !connections.top && connections.right && connections.bottom ? new int[]{2, 2} : (connections.left && !connections.top && !connections.right && connections.bottom ? new int[]{3, 2} : (!connections.left ? new int[]{0, 2} : (!connections.top ? new int[]{1, 2} : (!connections.right ? new int[]{1, 3} : (!connections.bottom ? new int[]{0, 3} : new int[]{1, 0}))))))))))))));
            return uv;
        }),
        VERTICAL(1, 4, connections -> {
            int[] uv = connections.top && connections.bottom ? new int[]{0, 2} : (connections.top ? new int[]{0, 3} : (connections.bottom ? new int[]{0, 1} : new int[]{0, 0}));
            return uv;
        }),
        COMPACT(5, 1, connections -> {
            int[] uv = null;
            int sides = (connections.left ? 1 : 0) + (connections.top ? 1 : 0) + (connections.right ? 1 : 0) + (connections.bottom ? 1 : 0);
            if (sides == 0 || sides == 1) {
                uv = new int[]{0, 0};
            } else if (sides == 2) {
                uv = connections.left && connections.right ? new int[]{3, 0} : (connections.top && connections.bottom ? new int[]{2, 0} : new int[]{0, 0});
            } else if (sides == 3) {
                if (connections.left && connections.right) {
                    uv = connections.topLeft && connections.top && connections.topRight || connections.bottomLeft && connections.bottom && connections.bottomRight ? new int[]{3, 0} : new int[]{0, 0};
                } else if (connections.top && connections.bottom) {
                    uv = connections.topLeft && connections.left && connections.bottomLeft || connections.topRight && connections.right && connections.bottomRight ? new int[]{2, 0} : new int[]{0, 0};
                }
            } else if (sides == 4) {
                uv = connections.topLeft && connections.topRight && connections.bottomLeft && connections.bottomRight ? new int[]{1, 0} : (!connections.topLeft && !connections.topRight && !connections.bottomLeft && !connections.bottomRight ? new int[]{4, 0} : new int[]{0, 0});
            }
            return uv;
        });

        final int width;
        final int height;
        final Function<SurroundingBlockData.SideConnections, int[]> tilePicker;

        private LayoutProperties(int width, int height, Function<SurroundingBlockData.SideConnections, int[]> tilePicker) {
            this.width = width;
            this.height = height;
            this.tilePicker = tilePicker;
        }
    }
}

