/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;

public class SurroundingBlockData {
    private final Map<ResourceLocation, Map<Direction, SideConnections>> connections;
    private final int hashCode;

    public static SurroundingBlockData create(IBlockDisplayReader level, BlockPos pos, TransformationMatrix rotation, Map<ResourceLocation, ConnectionPredicate> predicates) {
        TransformationMatrix inverseRotation = rotation.func_227987_b_();
        Matrix4f rotationMatrix = inverseRotation == null ? TransformationMatrix.func_227983_a_().func_227988_c_() : rotation.func_227988_c_();
        Matrix4f inverseRotationMatrix = inverseRotation == null ? TransformationMatrix.func_227983_a_().func_227988_c_() : inverseRotation.func_227988_c_();
        BlockState[][][] states = new BlockState[3][3][3];
        BlockPos.Mutable statePos = new BlockPos.Mutable();
        for (int i = 0; i < 27; ++i) {
            statePos.func_181079_c(pos.func_177958_n() + i % 3 - 1, pos.func_177956_o() + i / 3 % 3 - 1, pos.func_177952_p() + i / 9 % 3 - 1);
            states[i % 3][i / 3 % 3][i / 9 % 3] = level.func_180495_p((BlockPos)statePos);
        }
        ImmutableMap.Builder connectionsBuilder = ImmutableMap.builder();
        for (ResourceLocation sprite : predicates.keySet()) {
            EnumMap<Direction, SideConnections> spriteConnections = new EnumMap<Direction, SideConnections>(Direction.class);
            for (Direction side : Direction.values()) {
                spriteConnections.put(side, SurroundingBlockData.getConnections(side, rotationMatrix, inverseRotationMatrix, states, predicates.get(sprite), level, pos));
            }
            connectionsBuilder.put((Object)sprite, spriteConnections);
        }
        return new SurroundingBlockData((Map<ResourceLocation, Map<Direction, SideConnections>>)connectionsBuilder.build());
    }

    private static SideConnections getConnections(Direction side, Matrix4f rotation, Matrix4f inverseRotation, BlockState[][][] states, ConnectionPredicate predicate, IBlockDisplayReader level, BlockPos pos) {
        Direction down;
        Direction up;
        Direction right;
        Direction left;
        Direction originalSide = Direction.func_229385_a_((Matrix4f)inverseRotation, (Direction)side);
        if (originalSide.func_176740_k() == Direction.Axis.Y) {
            left = Direction.WEST;
            right = Direction.EAST;
            up = originalSide == Direction.UP ? Direction.NORTH : Direction.SOUTH;
            down = originalSide == Direction.UP ? Direction.SOUTH : Direction.NORTH;
        } else {
            left = originalSide.func_176746_e();
            right = originalSide.func_176735_f();
            up = Direction.UP;
            down = Direction.DOWN;
        }
        left = Direction.func_229385_a_((Matrix4f)rotation, (Direction)left);
        right = Direction.func_229385_a_((Matrix4f)rotation, (Direction)right);
        up = Direction.func_229385_a_((Matrix4f)rotation, (Direction)up);
        down = Direction.func_229385_a_((Matrix4f)rotation, (Direction)down);
        BlockState self = states[1][1][1];
        boolean connectTop = SurroundingBlockData.shouldConnect(states, side, originalSide, self, up.func_82601_c(), up.func_96559_d(), up.func_82599_e(), ConnectionDirection.TOP, predicate, level, pos);
        boolean connectTopRight = SurroundingBlockData.shouldConnect(states, side, originalSide, self, up.func_82601_c() + right.func_82601_c(), up.func_96559_d() + right.func_96559_d(), up.func_82599_e() + right.func_82599_e(), ConnectionDirection.TOP_RIGHT, predicate, level, pos);
        boolean connectRight = SurroundingBlockData.shouldConnect(states, side, originalSide, self, right.func_82601_c(), right.func_96559_d(), right.func_82599_e(), ConnectionDirection.RIGHT, predicate, level, pos);
        boolean connectBottomRight = SurroundingBlockData.shouldConnect(states, side, originalSide, self, down.func_82601_c() + right.func_82601_c(), down.func_96559_d() + right.func_96559_d(), down.func_82599_e() + right.func_82599_e(), ConnectionDirection.BOTTOM_RIGHT, predicate, level, pos);
        boolean connectBottom = SurroundingBlockData.shouldConnect(states, side, originalSide, self, down.func_82601_c(), down.func_96559_d(), down.func_82599_e(), ConnectionDirection.BOTTOM, predicate, level, pos);
        boolean connectBottomLeft = SurroundingBlockData.shouldConnect(states, side, originalSide, self, down.func_82601_c() + left.func_82601_c(), down.func_96559_d() + left.func_96559_d(), down.func_82599_e() + left.func_82599_e(), ConnectionDirection.BOTTOM_LEFT, predicate, level, pos);
        boolean connectLeft = SurroundingBlockData.shouldConnect(states, side, originalSide, self, left.func_82601_c(), left.func_96559_d(), left.func_82599_e(), ConnectionDirection.LEFT, predicate, level, pos);
        boolean connectTopLeft = SurroundingBlockData.shouldConnect(states, side, originalSide, self, up.func_82601_c() + left.func_82601_c(), up.func_96559_d() + left.func_96559_d(), up.func_82599_e() + left.func_82599_e(), ConnectionDirection.TOP_LEFT, predicate, level, pos);
        return new SideConnections(side, connectTop, connectTopRight, connectRight, connectBottomRight, connectBottom, connectBottomLeft, connectLeft, connectTopLeft);
    }

    private static boolean shouldConnect(BlockState[][][] states, Direction side, Direction originalSide, BlockState self, int neighborX, int neighborY, int neighborZ, ConnectionDirection direction, ConnectionPredicate predicate, IBlockDisplayReader level, BlockPos pos) {
        BlockState otherState = states[neighborX + 1][neighborY + 1][neighborZ + 1];
        BlockState stateInFront = states[neighborX + 1 + side.func_82601_c()][neighborY + 1 + side.func_96559_d()][neighborZ + 1 + side.func_82599_e()];
        return predicate.shouldConnect((IBlockReader)level, pos, originalSide, self, otherState, stateInFront, direction);
    }

    private SurroundingBlockData(Map<ResourceLocation, Map<Direction, SideConnections>> connections) {
        this.connections = connections;
        this.hashCode = this.connections.hashCode();
    }

    public SideConnections getConnections(ResourceLocation sprite, Direction side) {
        return (SideConnections)this.connections.getOrDefault(sprite, Collections.emptyMap()).get(side);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof SurroundingBlockData && this.hashCode == ((SurroundingBlockData)obj).hashCode;
    }

    public static final class SideConnections {
        public final Direction side;
        public final boolean top;
        public final boolean topRight;
        public final boolean right;
        public final boolean bottomRight;
        public final boolean bottom;
        public final boolean bottomLeft;
        public final boolean left;
        public final boolean topLeft;
        public final int hash;

        public SideConnections(Direction side, boolean top, boolean topRight, boolean right, boolean bottomRight, boolean bottom, boolean bottomLeft, boolean left, boolean topLeft) {
            this.side = side;
            this.top = top;
            this.topRight = topRight;
            this.right = right;
            this.bottomRight = bottomRight;
            this.bottom = bottom;
            this.bottomLeft = bottomLeft;
            this.left = left;
            this.topLeft = topLeft;
            this.hash = Objects.hashCode((Object[])new Object[]{this.top, this.topRight, this.right, this.bottomRight, this.bottom, this.bottomLeft, this.left, this.topLeft});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SideConnections that = (SideConnections)o;
            return this.left == that.left && this.right == that.right && this.top == that.top && this.topLeft == that.topLeft && this.topRight == that.topRight && this.bottom == that.bottom && this.bottomLeft == that.bottomLeft && this.bottomRight == that.bottomRight && this.side == that.side;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

