/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.SpriteHelper;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureData;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import com.supermartijn642.fusion.model.WrappedBakedModel;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelType;
import com.supermartijn642.fusion.model.types.connecting.SurroundingBlockData;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureLayoutHelper;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class ConnectingBakedModel
extends WrappedBakedModel {
    private static final int BLOCK_VERTEX_DATA_UV_OFFSET = ConnectingBakedModel.findUVOffset(DefaultVertexFormats.field_176600_a);
    private static final ModelProperty<SurroundingBlockData> SURROUNDING_BLOCK_DATA_MODEL_PROPERTY = new ModelProperty();
    public static final ThreadLocal<Boolean> ignoreModelRenderTypeCheck = ThreadLocal.withInitial(() -> false);
    private final TransformationMatrix modelRotation;
    private final Map<ResourceLocation, ConnectionPredicate> predicates;
    private final Map<RenderKey, List<BakedQuad>> quadCache = new HashMap<RenderKey, List<BakedQuad>>();
    private final RenderKey mutableKey = new RenderKey(0, null, null);
    private List<RenderType> customRenderTypes;

    public ConnectingBakedModel(IBakedModel original, TransformationMatrix modelRotation, Map<ResourceLocation, ConnectionPredicate> predicates) {
        super(original);
        this.modelRotation = modelRotation;
        this.predicates = predicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random random, @Nonnull IModelData modelData) {
        List<BakedQuad> quads;
        SurroundingBlockData data = modelData.hasProperty(SURROUNDING_BLOCK_DATA_MODEL_PROPERTY) ? (SurroundingBlockData)modelData.getData(SURROUNDING_BLOCK_DATA_MODEL_PROPERTY) : null;
        int hashCode = data == null ? 0 : data.hashCode();
        RenderType renderType = MinecraftForgeClient.getRenderLayer();
        Map<RenderKey, List<BakedQuad>> map = this.quadCache;
        synchronized (map) {
            this.mutableKey.update(hashCode, side, renderType);
            quads = this.quadCache.get(this.mutableKey);
        }
        if (quads == null) {
            ignoreModelRenderTypeCheck.set(true);
            boolean isOriginalRenderType = state == null || renderType == null || RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)renderType);
            ignoreModelRenderTypeCheck.set(false);
            quads = this.remapQuads(this.original.getQuads(state, side, random, modelData), data, renderType, isOriginalRenderType);
            Map<RenderKey, List<BakedQuad>> map2 = this.quadCache;
            synchronized (map2) {
                this.mutableKey.update(hashCode, side, renderType);
                if (!this.quadCache.containsKey(this.mutableKey)) {
                    RenderKey key = new RenderKey(hashCode, side, renderType);
                    this.quadCache.put(key, quads);
                } else {
                    quads = this.quadCache.get(this.mutableKey);
                }
            }
        }
        if (quads == null) {
            throw new IllegalStateException("Tried returning null list from ConnectingBakedModel#getQuads for side '" + side + "'!");
        }
        return quads;
    }

    private List<BakedQuad> remapQuads(List<BakedQuad> originalQuads, SurroundingBlockData surroundingBlocks, RenderType renderType, boolean originalRenderType) {
        if (surroundingBlocks == null) {
            return originalQuads;
        }
        return originalQuads.stream().map(quad -> this.remapQuad((BakedQuad)quad, surroundingBlocks, renderType, originalRenderType)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected BakedQuad remapQuad(BakedQuad quad, SurroundingBlockData surroundingBlocks, RenderType renderType, boolean originalRenderType) {
        TextureAtlasSprite sprite = quad.func_187508_a();
        if (SpriteHelper.getTextureType(sprite) != DefaultTextureTypes.CONNECTING) {
            return originalRenderType ? quad : null;
        }
        ConnectingTextureData.RenderType spriteRenderType = ((ConnectingTextureSprite)sprite).getRenderType();
        if (spriteRenderType == null ? !originalRenderType : FusionClient.getRenderTypeMaterial(spriteRenderType) != renderType) {
            return null;
        }
        ConnectingTextureLayout layout = ((ConnectingTextureSprite)sprite).getLayout();
        int[] vertexData = quad.func_178209_a();
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        ResourceLocation spriteIdentifier = sprite.func_195668_m();
        if (spriteIdentifier == null || !this.predicates.containsKey(spriteIdentifier)) {
            spriteIdentifier = ConnectingModelType.DEFAULT_CONNECTION_KEY;
        }
        SurroundingBlockData.SideConnections connections = surroundingBlocks.getConnections(spriteIdentifier, quad.func_178210_d());
        int[] uv = ConnectingTextureLayoutHelper.getStatePosition(layout, connections);
        ConnectingBakedModel.adjustVertexDataUV(vertexData, uv[0], uv[1], sprite);
        return new BakedQuad(vertexData, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.func_239287_f_());
    }

    private static int[] adjustVertexDataUV(int[] vertexData, int newU, int newV, TextureAtlasSprite sprite) {
        int vertexSize = DefaultVertexFormats.field_176600_a.func_181719_f();
        int vertices = vertexData.length / vertexSize;
        int uvOffset = BLOCK_VERTEX_DATA_UV_OFFSET / 4;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize + uvOffset;
            float width = sprite.func_94212_f() - sprite.func_94209_e();
            float u = Float.intBitsToFloat(vertexData[offset]) + width * (float)newU;
            vertexData[offset] = Float.floatToRawIntBits(u);
            float height = sprite.func_94210_h() - sprite.func_94206_g();
            float v = Float.intBitsToFloat(vertexData[offset + 1]) + height * (float)newV;
            vertexData[offset + 1] = Float.floatToRawIntBits(v);
        }
        return vertexData;
    }

    private static int findUVOffset(VertexFormat vertexFormat) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < vertexFormat.func_227894_c_().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)vertexFormat.func_227894_c_().get(index);
            if (el.func_177375_c() != VertexFormatElement.Usage.UV) continue;
            element = el;
            break;
        }
        if (index == vertexFormat.func_227894_c_().size() || element == null) {
            throw new RuntimeException("Expected vertex format to have a UV attribute");
        }
        if (element.func_177367_b() != VertexFormatElement.Type.FLOAT) {
            throw new RuntimeException("Expected UV attribute to have data type FLOAT");
        }
        if (element.func_177368_f() < 4) {
            throw new RuntimeException("Expected UV attribute to have at least 4 dimensions");
        }
        return vertexFormat.field_177356_c.getInt(index);
    }

    public SurroundingBlockData getModelData(IBlockDisplayReader level, BlockPos pos, BlockState state) {
        return SurroundingBlockData.create(level, pos, this.modelRotation, this.predicates);
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData modelData) {
        return new ModelDataMap.Builder().withInitial(SURROUNDING_BLOCK_DATA_MODEL_PROPERTY, (Object)this.getModelData(level, pos, state)).build();
    }

    public List<RenderType> getCustomRenderTypes() {
        if (this.customRenderTypes == null) {
            this.calculateCustomRenderTypes();
        }
        return this.customRenderTypes;
    }

    private void calculateCustomRenderTypes() {
        HashSet renderTypes = new HashSet();
        for (Direction cullFace : new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, null}) {
            this.original.func_200117_a(null, cullFace, new Random(42L)).stream().map(BakedQuad::func_187508_a).filter(sprite -> SpriteHelper.getTextureType(sprite) == DefaultTextureTypes.CONNECTING).map(sprite -> ((ConnectingTextureSprite)((Object)sprite)).getRenderType()).filter(Objects::nonNull).map(FusionClient::getRenderTypeMaterial).forEach(renderTypes::add);
        }
        this.customRenderTypes = Arrays.asList(renderTypes.toArray(new RenderType[0]));
    }

    @Override
    public boolean func_188618_c() {
        return super.func_188618_c();
    }

    @Override
    public ItemCameraTransforms func_177552_f() {
        return super.func_177552_f();
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private static class RenderKey {
        private int surroundingBlockData;
        private Direction face;
        private RenderType renderType;

        private RenderKey(int surroundingBlockData, Direction face, RenderType renderType) {
            this.surroundingBlockData = surroundingBlockData;
            this.face = face;
            this.renderType = renderType;
        }

        void update(int surroundingBlockData, Direction face, RenderType renderType) {
            this.surroundingBlockData = surroundingBlockData;
            this.face = face;
            this.renderType = renderType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenderKey renderKey = (RenderKey)o;
            if (this.surroundingBlockData != renderKey.surroundingBlockData) {
                return false;
            }
            if (this.face != renderKey.face) {
                return false;
            }
            return Objects.equals(this.renderType, renderKey.renderType);
        }

        public int hashCode() {
            int result = this.surroundingBlockData;
            result = 31 * result + (this.face != null ? this.face.hashCode() : 0);
            result = 31 * result + (this.renderType != null ? this.renderType.hashCode() : 0);
            return result;
        }
    }
}

