/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.supermartijn642.fusion.extensions.PackResourcesExtension;
import com.supermartijn642.fusion.resources.FusionPackMetadataSection;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.forgespi.locating.IModFile;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModFileResourcePack.class})
public class ModFileResourcePackMixin
implements PackResourcesExtension {
    @Final
    @Shadow(remap=false)
    private ModFile modFile;
    @Unique
    private String overridesFolderName;

    @Override
    public void setFusionOverridesFolder(@Nonnull String folder) {
        this.overridesFolderName = folder.replaceAll("/$", "");
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(ModFile mf, CallbackInfo ci) {
        ModFileResourcePack resources = (ModFileResourcePack)this;
        if (resources instanceof PackResourcesExtension) {
            String overridesFolder;
            Path path = mf.findResource("pack.mcmeta");
            try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                overridesFolder = (String)ResourcePack.func_195770_a((IMetadataSectionSerializer)FusionPackMetadataSection.INSTANCE, (InputStream)stream);
            }
            catch (IOException ignored) {
                return;
            }
            if (overridesFolder != null) {
                ((PackResourcesExtension)resources).setFusionOverridesFolder(overridesFolder);
            }
        }
    }

    @Inject(method={"getResource(Ljava/lang/String;)Ljava/io/InputStream;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getResource(String path, CallbackInfoReturnable<InputStream> ci) throws IOException {
        if (this.overridesFolderName == null) {
            return;
        }
        Path resolvedPath = this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{this.overridesFolderName, path});
        if (Files.exists(resolvedPath, new LinkOption[0])) {
            ci.setReturnValue((Object)Files.newInputStream(resolvedPath, StandardOpenOption.READ));
        }
    }

    @Inject(method={"hasResource(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void hasResource(String path, CallbackInfoReturnable<Boolean> ci) {
        if (this.overridesFolderName == null) {
            return;
        }
        if (Files.exists(this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{this.overridesFolderName, path}), new LinkOption[0])) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getNamespaces"}, at={@At(value="RETURN")}, cancellable=true)
    private void getNamespaces(ResourcePackType type, CallbackInfoReturnable<Set<String>> ci) {
        if (this.overridesFolderName == null) {
            return;
        }
        HashSet namespaces = Sets.newHashSet((Iterable)((Iterable)ci.getReturnValue()));
        Path typeFolder = this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{this.overridesFolderName, type.func_198956_a()}).toAbsolutePath();
        try (Stream<Path> walker = Files.walk(typeFolder, 1, new FileVisitOption[0]);){
            walker.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(typeFolder::relativize).filter(p -> p.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).forEach(namespaces::add);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ci.setReturnValue((Object)namespaces);
    }

    @Inject(method={"getResources"}, at={@At(value="RETURN")}, cancellable=true)
    private void getResources(ResourcePackType type, String namespace, String folderName, int depth, Predicate<String> predicate, CallbackInfoReturnable<Collection<ResourceLocation>> ci) {
        if (this.overridesFolderName == null) {
            return;
        }
        if (ci.getReturnValue() == null) {
            return;
        }
        ArrayList locations = new ArrayList((Collection)ci.getReturnValue());
        Set names = locations.stream().map(ResourceLocation::func_110623_a).map(s -> s.startsWith(folderName) ? s.substring(folderName.length()) : s).collect(Collectors.toSet());
        Path namespaceFolder = this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{this.overridesFolderName, type.func_198956_a(), namespace}).toAbsolutePath();
        Path searchFolder = namespaceFolder.getFileSystem().getPath(folderName, new String[0]);
        try (Stream<Path> walker = Files.walk(namespaceFolder, new FileVisitOption[0]);){
            walker.map(namespaceFolder::relativize).filter(path -> path.getNameCount() <= depth && !path.toString().endsWith(".mcmeta") && path.startsWith(searchFolder)).filter(path -> !names.contains(path.getFileName().toString())).filter(path -> predicate.test(path.getFileName().toString())).map(arg_0 -> ((Joiner)Joiner.on((char)'/')).join(arg_0)).filter(s -> s.matches("[a-z0-9_/.-]+")).map(path -> new ResourceLocation(namespace, path)).forEach(locations::add);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ci.setReturnValue(locations);
    }
}

