/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion;

import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.FusionModelTypeRegistry;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.FusionTextureTypeRegistry;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureData;
import com.supermartijn642.fusion.predicate.AndConnectionPredicate;
import com.supermartijn642.fusion.predicate.IsFaceVisibleConnectionPredicate;
import com.supermartijn642.fusion.predicate.IsSameBlockConnectionPredicate;
import com.supermartijn642.fusion.predicate.IsSameStateConnectionPredicate;
import com.supermartijn642.fusion.predicate.MatchBlockConnectionPredicate;
import com.supermartijn642.fusion.predicate.MatchStateConnectionPredicate;
import com.supermartijn642.fusion.predicate.NotConnectionPredicate;
import com.supermartijn642.fusion.predicate.OrConnectionPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FusionClient {
    public static final Logger LOGGER = LogManager.getLogger((String)"fusion");
    private static NativeImage dummyImage;

    public static NativeImage getDummyImage() {
        if (dummyImage == null) {
            dummyImage = new NativeImage(NativeImage.PixelFormat.RGBA, 1, 1, false);
            dummyImage.func_195700_a(0, 0, -1);
        }
        return dummyImage;
    }

    public static void init() {
        FusionTextureTypeRegistry.registerTextureType(new ResourceLocation("fusion", "vanilla"), DefaultTextureTypes.VANILLA);
        FusionTextureTypeRegistry.registerTextureType(new ResourceLocation("fusion", "connecting"), DefaultTextureTypes.CONNECTING);
        FusionTextureTypeRegistry.registerTextureType(new ResourceLocation("fusion", "scrolling"), DefaultTextureTypes.SCROLLING);
        FusionModelTypeRegistry.registerModelType(new ResourceLocation("fusion", "unknown"), DefaultModelTypes.UNKNOWN);
        FusionModelTypeRegistry.registerModelType(new ResourceLocation("fusion", "vanilla"), DefaultModelTypes.VANILLA);
        FusionModelTypeRegistry.registerModelType(new ResourceLocation("fusion", "connecting"), DefaultModelTypes.CONNECTING);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "and"), AndConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "or"), OrConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "not"), NotConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "is_face_visible"), IsFaceVisibleConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "is_same_block"), IsSameBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "is_same_state"), IsSameStateConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "match_block"), MatchBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "match_state"), MatchStateConnectionPredicate.SERIALIZER);
    }

    public static RenderType getRenderTypeMaterial(ConnectingTextureData.RenderType renderType) {
        RenderType material;
        switch (renderType) {
            case OPAQUE: {
                material = RenderType.func_228639_c_();
                break;
            }
            case CUTOUT: {
                material = RenderType.func_228643_e_();
                break;
            }
            case TRANSLUCENT: {
                material = RenderType.func_228645_f_();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return material;
    }
}

