/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.redstone_relay;

import com.mrh0.createaddition.blocks.redstone_relay.RedstoneRelayTileEntity;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.index.CATileEntities;
import com.mrh0.createaddition.shapes.CAShapes;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.VoxelShaper;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RedstoneRelay
extends Block
implements ITE<RedstoneRelayTileEntity>,
IWrenchable {
    public static final BooleanProperty VERTICAL = BooleanProperty.func_177716_a((String)"vertical");
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final VoxelShape HORIZONTAL_SHAPE_MAIN = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape HORIZONTAL_SHAPE_X = VoxelShapes.func_216384_a((VoxelShape)HORIZONTAL_SHAPE_MAIN, (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)1.0, (double)0.0, (double)6.0, (double)5.0, (double)7.0, (double)10.0), Block.func_208617_a((double)11.0, (double)0.0, (double)6.0, (double)15.0, (double)7.0, (double)10.0)});
    public static final VoxelShape HORIZONTAL_SHAPE_Z = VoxelShapes.func_216384_a((VoxelShape)HORIZONTAL_SHAPE_MAIN, (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.0, (double)0.0, (double)1.0, (double)10.0, (double)7.0, (double)5.0), Block.func_208617_a((double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)7.0, (double)15.0)});
    public static final VoxelShaper VERTICAL_SHAPE = CAShapes.shape(0.0, 0.0, 0.0, 16.0, 2.0, 16.0).add(1.0, 0.0, 6.0, 5.0, 7.0, 10.0).add(11.0, 0.0, 6.0, 15.0, 7.0, 10.0).forDirectional();
    protected static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);

    public RedstoneRelay(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)VERTICAL, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public Class<RedstoneRelayTileEntity> getTileEntityClass() {
        return RedstoneRelayTileEntity.class;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction dir = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
        if (((Boolean)state.func_177229_b((Property)VERTICAL)).booleanValue()) {
            return VERTICAL_SHAPE.get(dir.func_176734_d());
        }
        Direction.Axis axis = dir.func_176740_k();
        return axis == Direction.Axis.X ? HORIZONTAL_SHAPE_X : HORIZONTAL_SHAPE_Z;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return CATileEntities.REDSTONE_RELAY.create();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{VERTICAL, HORIZONTAL_FACING, POWERED});
    }

    public BlockState func_196258_a(BlockItemUseContext c) {
        if (c.func_196000_l().func_176740_k() == Direction.Axis.Y) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, (Comparable)(c.func_195999_j().func_225608_bj_() ? c.func_195992_f().func_176735_f() : c.func_195992_f().func_176746_e()))).func_206870_a((Property)VERTICAL, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, (Comparable)c.func_196000_l().func_176734_d())).func_206870_a((Property)VERTICAL, (Comparable)Boolean.valueOf(true));
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        boolean flag = (Boolean)state.func_177229_b((Property)POWERED);
        boolean flag1 = this.shouldBePowered((World)worldIn, pos, state);
        if (flag && !flag1) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (!flag) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.func_196955_c((IWorldReader)worldIn, pos)) {
            this.updateState(worldIn, pos, state);
        } else {
            TileEntity tileentity = state.hasTileEntity() ? worldIn.func_175625_s(pos) : null;
            RedstoneRelay.func_220059_a((BlockState)state, (IWorld)worldIn, (BlockPos)pos, (TileEntity)tileentity);
            worldIn.func_217377_a(pos, false);
            for (Direction direction : Direction.values()) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        boolean vertical = (Boolean)state.func_177229_b((Property)VERTICAL);
        Direction direction = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
        return RedstoneRelay.func_220055_a((IWorldReader)world, (BlockPos)(vertical ? pos.func_177972_a(direction) : pos.func_177977_b()), (Direction)(vertical ? direction.func_176734_d() : Direction.UP));
    }

    protected void updateState(World worldIn, BlockPos pos, BlockState state) {
        boolean flag1;
        boolean flag = (Boolean)state.func_177229_b((Property)POWERED);
        if (flag != (flag1 = this.shouldBePowered(worldIn, pos, state)) && !worldIn.func_205220_G_().func_205361_b(pos, (Object)this)) {
            TickPriority tickpriority = TickPriority.VERY_HIGH;
            worldIn.func_205220_G_().func_205362_a(pos, (Object)this, this.getDelay(state), tickpriority);
        }
    }

    private int getDelay(BlockState state) {
        return 2;
    }

    protected boolean shouldBePowered(World worldIn, BlockPos pos, BlockState state) {
        return this.calculateInputStrength(worldIn, pos, state) > 0;
    }

    protected int calculateInputStrength(World worldIn, BlockPos pos, BlockState state) {
        boolean vertical = (Boolean)state.func_177229_b((Property)VERTICAL);
        if (vertical) {
            BlockPos blockpos1 = pos.func_177972_a(Direction.UP);
            BlockPos blockpos2 = pos.func_177972_a(Direction.DOWN);
            int i = Math.max(worldIn.func_175651_c(blockpos1, Direction.DOWN), worldIn.func_175651_c(blockpos2, Direction.UP));
            BlockState blockstate1 = worldIn.func_180495_p(blockpos1);
            BlockState blockstate2 = worldIn.func_180495_p(blockpos2);
            return Math.max(i, Math.max(blockstate1.func_203425_a(Blocks.field_150488_af) ? (Integer)blockstate1.func_177229_b((Property)RedstoneWireBlock.field_176351_O) : 0, blockstate2.func_203425_a(Blocks.field_150488_af) ? (Integer)blockstate2.func_177229_b((Property)RedstoneWireBlock.field_176351_O) : 0));
        }
        Direction direction = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
        BlockPos blockpos1 = pos.func_177972_a(direction.func_176746_e());
        BlockPos blockpos2 = pos.func_177972_a(direction.func_176735_f());
        int i = Math.max(worldIn.func_175651_c(blockpos1, direction.func_176746_e()), worldIn.func_175651_c(blockpos2, direction.func_176735_f()));
        int j = Math.max(worldIn.func_175627_a(blockpos1, direction.func_176746_e()), worldIn.func_175627_a(blockpos2, direction.func_176735_f()));
        BlockState blockstate1 = worldIn.func_180495_p(blockpos1);
        BlockState blockstate2 = worldIn.func_180495_p(blockpos2);
        return Math.max(Math.max(i, j), Math.max(blockstate1.func_203425_a(Blocks.field_150488_af) ? (Integer)blockstate1.func_177229_b((Property)RedstoneWireBlock.field_176351_O) : 0, blockstate2.func_203425_a(Blocks.field_150488_af) ? (Integer)blockstate2.func_177229_b((Property)RedstoneWireBlock.field_176351_O) : 0));
    }

    protected int getPowerOnSides(IWorldReader worldIn, BlockPos pos, Direction direction) {
        Direction direction1 = direction.func_176746_e();
        Direction direction2 = direction.func_176735_f();
        return Math.max(this.getPowerOnSide(worldIn, pos.func_177972_a(direction1), direction2), this.getPowerOnSide(worldIn, pos.func_177972_a(direction2), direction1));
    }

    protected int getPowerOnSide(IWorldReader worldIn, BlockPos pos, Direction side) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        if (this.isAlternateInput(blockstate)) {
            if (blockstate.func_203425_a(Blocks.field_150451_bX)) {
                return 15;
            }
            return blockstate.func_203425_a(Blocks.field_150488_af) ? ((Integer)blockstate.func_177229_b((Property)RedstoneWireBlock.field_176351_O)).intValue() : worldIn.func_175627_a(pos, side);
        }
        return 0;
    }

    protected boolean isAlternateInput(BlockState state) {
        return state.func_185897_m();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.shouldBePowered(worldIn, pos, state)) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
        if (player.func_184812_l_()) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null) {
            return;
        }
        if (!(te instanceof IWireNode)) {
            return;
        }
        IWireNode cte = (IWireNode)te;
        cte.dropWires(worldIn);
    }

    public ActionResultType onSneakWrenched(BlockState state, ItemUseContext c) {
        if (c.func_195999_j().func_184812_l_()) {
            return super.onSneakWrenched(state, c);
        }
        TileEntity te = c.func_195991_k().func_175625_s(c.func_195995_a());
        if (te == null) {
            return super.onSneakWrenched(state, c);
        }
        if (!(te instanceof IWireNode)) {
            return super.onSneakWrenched(state, c);
        }
        IWireNode cte = (IWireNode)te;
        cte.dropWires(c.func_195991_k(), c.func_195999_j());
        return super.onSneakWrenched(state, c);
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return (Boolean)state.func_177229_b((Property)VERTICAL) == false && side.func_176740_k() != ((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)).func_176740_k();
    }
}

