/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.util.unit;

import dev.latvian.mods.rhino.util.unit.ColorUnit;
import dev.latvian.mods.rhino.util.unit.ConstantUnit;
import dev.latvian.mods.rhino.util.unit.FuncSupplier;
import dev.latvian.mods.rhino.util.unit.IfUnit;
import dev.latvian.mods.rhino.util.unit.OpSupplier;
import dev.latvian.mods.rhino.util.unit.RandomUnit;
import dev.latvian.mods.rhino.util.unit.TimeUnit;
import dev.latvian.mods.rhino.util.unit.Unit;
import dev.latvian.mods.rhino.util.unit.UnitParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class UnitStorage {
    private final Map<String, Unit> variables = new HashMap<String, Unit>();
    private final Map<String, ConstantUnit> constants = new HashMap<String, ConstantUnit>();
    private final Map<String, OpSupplier> operations = new HashMap<String, OpSupplier>();
    private final Map<String, FuncSupplier> functions = new HashMap<String, FuncSupplier>();
    private long variableVersion = 0L;

    public UnitStorage() {
        this.addConstant("PI", (float)Math.PI);
        this.addConstant("E", (float)Math.E);
        this.addConstant("true", 1.0f);
        this.addConstant("false", 0.0f);
        this.addOp("+", Unit::add);
        this.addOp("-", Unit::sub);
        this.addOp("*", Unit::mul);
        this.addOp("/", Unit::div);
        this.addOp("%", Unit::mod);
        this.addOp("**", Unit::pow);
        this.addOp("<<", Unit::shiftLeft);
        this.addOp(">>", Unit::shiftRight);
        this.addOp("&", Unit::and);
        this.addOp("&&", Unit::and);
        this.addOp("|", Unit::or);
        this.addOp("||", Unit::or);
        this.addOp("^", Unit::xor);
        this.addOp("==", Unit::eq);
        this.addOp("!=", Unit::neq);
        this.addOp("~=", Unit::neq);
        this.addOp(">", Unit::gt);
        this.addOp("<", Unit::lt);
        this.addOp(">=", Unit::gte);
        this.addOp("<=", Unit::lte);
        this.addFunc("random", RandomUnit.INSTANCE);
        this.addFunc("time", TimeUnit.INSTANCE);
        this.addFunc2("min", Unit::min);
        this.addFunc2("max", Unit::max);
        this.addFunc2("pow", Unit::pow);
        this.addFunc1("abs", Unit::abs);
        this.addFunc1("sin", Unit::sin);
        this.addFunc1("cos", Unit::cos);
        this.addFunc1("tan", Unit::tan);
        this.addFunc1("deg", Unit::deg);
        this.addFunc1("rad", Unit::rad);
        this.addFunc1("atan", Unit::atan);
        this.addFunc2("atan2", Unit::atan2);
        this.addFunc1("log", Unit::log);
        this.addFunc1("log10", Unit::log10);
        this.addFunc1("log1p", Unit::log1p);
        this.addFunc1("sqrt", Unit::sqrt);
        this.addFunc1("sq", Unit::sq);
        this.addFunc1("floor", Unit::floor);
        this.addFunc1("ceil", Unit::ceil);
        this.addFunc1("bool", Unit::toBool);
        this.addFunc("if", a -> new IfUnit((Unit)a.get(0), (Unit)a.get(1), (Unit)a.get(2)));
        this.addFunc("color", a -> new ColorUnit((Unit)a.get(0), (Unit)a.get(1), (Unit)a.get(2), a.size() >= 4 ? (Unit)a.get(3) : null));
    }

    public void clearVariables() {
        this.variables.clear();
    }

    public void setVariable(String key, Unit unit) {
        this.variables.put(key, unit);
        ++this.variableVersion;
    }

    @Nullable
    public Unit getVariable(String key) {
        return this.variables.get(key);
    }

    public long getVariableVersion() {
        return this.variableVersion;
    }

    public void addConstant(String name, float val) {
        this.constants.put(name, new ConstantUnit(name, val));
    }

    public void addOp(String name, OpSupplier op) {
        this.operations.put(name, op);
    }

    public void addFunc(String name, FuncSupplier func) {
        this.functions.put(name, func);
    }

    public void addFunc1(String name, FuncSupplier.Func1 func) {
        this.addFunc(name, func);
    }

    public void addFunc2(String name, FuncSupplier.Func2 func) {
        this.addFunc(name, func);
    }

    @Nullable
    public ConstantUnit getConstant(String name) {
        return this.constants.get(name);
    }

    @Nullable
    public Unit createOp(String name, Unit unit, Unit with) {
        OpSupplier op = this.operations.get(name);
        return op == null ? null : op.create(unit, with);
    }

    @Nullable
    public Unit createFunc(String name, List<Unit> args) {
        FuncSupplier func = this.functions.get(name);
        return func == null ? null : func.create(args);
    }

    public Unit parse(String string) {
        return new UnitParser(string, this).parse();
    }
}

