/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.util.unit;

import dev.latvian.mods.rhino.util.unit.ColorUnit;
import dev.latvian.mods.rhino.util.unit.ConstantUnit;
import dev.latvian.mods.rhino.util.unit.FixedUnit;
import dev.latvian.mods.rhino.util.unit.Unit;
import dev.latvian.mods.rhino.util.unit.UnitParserException;
import dev.latvian.mods.rhino.util.unit.UnitStorage;
import dev.latvian.mods.rhino.util.unit.VariableUnit;
import java.util.ArrayList;

class UnitParser {
    private final String string;
    private final char[] chars;
    private int pos;
    private final UnitStorage storage;

    public UnitParser(String s, UnitStorage st) {
        this.string = s;
        this.chars = this.string.trim().toCharArray();
        this.pos = 0;
        this.storage = st;
    }

    private boolean isEOL() {
        return this.pos >= this.chars.length;
    }

    private void move() {
        if (this.isEOL()) {
            throw new UnitParserException(this.string, this.pos, "End of line!");
        }
        ++this.pos;
    }

    private char peek() {
        if (this.isEOL()) {
            throw new UnitParserException(this.string, this.pos, "End of line!");
        }
        return this.chars[this.pos];
    }

    private char read() {
        char c = this.peek();
        this.move();
        return c;
    }

    private void readClose(int startPos) {
        this.skipS();
        if (this.read() != ')') {
            throw new UnitParserException(this.string, startPos, "Expected ) at " + this.pos);
        }
    }

    private boolean isW(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    private String readW() {
        int p0 = this.pos;
        while (!this.isEOL() && this.isW(this.peek())) {
            this.move();
        }
        return new String(this.chars, p0, this.pos - p0);
    }

    private boolean isN(char c) {
        return c >= '0' && c <= '9' || c == '.';
    }

    private String readN() {
        int p0 = this.pos;
        while (!this.isEOL() && this.isN(this.peek())) {
            this.move();
        }
        return new String(this.chars, p0, this.pos - p0);
    }

    private boolean isSym(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '%' || c == '>' || c == '<' || c == '!' || c == '=' || c == '~' || c == '^';
    }

    private String readSym() {
        int p0 = this.pos;
        while (!this.isEOL() && this.isSym(this.peek())) {
            this.move();
        }
        return new String(this.chars, p0, this.pos - p0);
    }

    private boolean isS(char c) {
        return c <= ' ';
    }

    private void skipS() {
        while (!this.isEOL() && this.isS(this.peek())) {
            this.move();
        }
    }

    public Unit parse() {
        int startPos = this.pos;
        try {
            return this.readUnit();
        }
        catch (StackOverflowError ex) {
            ex.printStackTrace();
            throw new UnitParserException(this.string, startPos, "Stack overflow!");
        }
    }

    public Unit readUnit() {
        this.skipS();
        int startPos = this.pos;
        char start = this.peek();
        if (start == '$') {
            this.move();
            return new VariableUnit(this.storage, this.readW());
        }
        if (start == '-') {
            this.move();
            return this.readUnit().neg();
        }
        if (start == '~' || start == '!') {
            this.move();
            return this.readUnit().not();
        }
        if (start == '#') {
            this.move();
            String hex = this.readW();
            int i = Long.decode("#" + hex).intValue();
            int r = i >> 16 & 0xFF;
            int g = i >> 8 & 0xFF;
            int b = i & 0xFF;
            int a = i >> 24 & 0xFF;
            return new ColorUnit(FixedUnit.of(r), FixedUnit.of(g), FixedUnit.of(b), hex.length() == 6 ? null : FixedUnit.of(a));
        }
        if (start >= '0' && start <= '9') {
            return FixedUnit.of(Float.parseFloat(this.readN()));
        }
        if (start == '(') {
            this.move();
            Unit unit = this.readUnit();
            this.skipS();
            String c = this.readSym();
            Unit with = this.readUnit();
            this.readClose(startPos);
            Unit u = this.storage.createOp(c, unit, with);
            if (u == null) {
                throw new UnitParserException(this.string, startPos, "Unknown operation " + c);
            }
            return u;
        }
        if (this.isW(start)) {
            ArrayList<Unit> args;
            String func;
            block17: {
                func = this.readW();
                ConstantUnit constant = this.storage.getConstant(func);
                if (constant != null) {
                    return constant;
                }
                this.skipS();
                if (this.read() != '(') {
                    throw new UnitParserException(this.string, startPos, "Unknown constant '" + func + "' at " + this.pos);
                }
                args = new ArrayList<Unit>(2);
                this.skipS();
                if (this.peek() != ')') {
                    args.add(this.readUnit());
                    while (true) {
                        this.skipS();
                        char c = this.read();
                        switch (c) {
                            case ',': {
                                args.add(this.readUnit());
                                break;
                            }
                            case ')': {
                                break block17;
                            }
                            default: {
                                throw new UnitParserException(this.string, startPos, "Unexpected character " + c + ", expected ) or ,!");
                            }
                        }
                    }
                }
                this.readClose(startPos);
            }
            Unit function = this.storage.createFunc(func, args);
            if (function != null) {
                return function;
            }
            throw new UnitParserException(this.string, startPos, "Unknown function " + func);
        }
        throw new UnitParserException(this.string, startPos, "Unknown syntax");
    }
}

