/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.util;

import dev.latvian.mods.rhino.mod.util.NBTSerializable;
import dev.latvian.mods.rhino.mod.util.OrderedCompoundTag;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.INBTType;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTypes;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.Nullable;

public class NBTUtils {
    private static final INBTType<OrderedCompoundTag> COMPOUND_TYPE = new INBTType<OrderedCompoundTag>(){

        public OrderedCompoundTag load(DataInput dataInput, int i, NBTSizeTracker nbtAccounter) throws IOException {
            byte b;
            nbtAccounter.func_152450_a(384L);
            if (i > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            LinkedHashMap<String, INBT> map = new LinkedHashMap<String, INBT>();
            while ((b = dataInput.readByte()) != 0) {
                String string = dataInput.readUTF();
                nbtAccounter.func_152450_a(224L + 16L * (long)string.length());
                INBTType tagType = NBTUtils.convertType(NBTTypes.func_229710_a_((int)b));
                INBT tag = tagType.func_225649_b_(dataInput, i + 1, nbtAccounter);
                if (map.put(string, tag) == null) continue;
                nbtAccounter.func_152450_a(288L);
            }
            return new OrderedCompoundTag(map);
        }

        public String func_225648_a_() {
            return "COMPOUND";
        }

        public String func_225650_b_() {
            return "TAG_Compound";
        }
    };
    private static final INBTType<ListNBT> LIST_TYPE = new INBTType<ListNBT>(){

        public ListNBT load(DataInput dataInput, int i, NBTSizeTracker nbtAccounter) throws IOException {
            nbtAccounter.func_152450_a(296L);
            if (i > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            byte b = dataInput.readByte();
            int j = dataInput.readInt();
            if (b == 0 && j > 0) {
                throw new RuntimeException("Missing type on ListTag");
            }
            nbtAccounter.func_152450_a(32L * (long)j);
            INBTType tagType = NBTUtils.convertType(NBTTypes.func_229710_a_((int)b));
            ListNBT list = new ListNBT();
            for (int k = 0; k < j; ++k) {
                list.add((Object)tagType.func_225649_b_(dataInput, i + 1, nbtAccounter));
            }
            return list;
        }

        public String func_225648_a_() {
            return "LIST";
        }

        public String func_225650_b_() {
            return "TAG_List";
        }
    };

    @Nullable
    public static INBT toNBT(@Nullable Object o) {
        if (o instanceof INBT) {
            return (INBT)o;
        }
        if (o instanceof NBTSerializable) {
            return ((NBTSerializable)o).toNBT();
        }
        if (o instanceof CharSequence || o instanceof Character) {
            return StringNBT.func_229705_a_((String)o.toString());
        }
        if (o instanceof Boolean) {
            return ByteNBT.func_229671_a_((byte)((Boolean)o != false ? (byte)1 : 0));
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            if (number instanceof Byte) {
                return ByteNBT.func_229671_a_((byte)number.byteValue());
            }
            if (number instanceof Short) {
                return ShortNBT.func_229701_a_((short)number.shortValue());
            }
            if (number instanceof Integer) {
                return IntNBT.func_229692_a_((int)number.intValue());
            }
            if (number instanceof Long) {
                return LongNBT.func_229698_a_((long)number.longValue());
            }
            if (number instanceof Float) {
                return FloatNBT.func_229689_a_((float)number.floatValue());
            }
            return DoubleNBT.func_229684_a_((double)number.doubleValue());
        }
        if (o instanceof Map) {
            OrderedCompoundTag tag = new OrderedCompoundTag();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                INBT nbt1 = NBTUtils.toNBT(entry.getValue());
                if (nbt1 == null) continue;
                tag.func_218657_a(String.valueOf(entry.getKey()), nbt1);
            }
            return tag;
        }
        if (o instanceof Collection) {
            return NBTUtils.toNBT((Collection)o);
        }
        return null;
    }

    public static CollectionNBT<?> toNBT(Collection<?> c) {
        Object[] array;
        if (c.isEmpty()) {
            return new ListNBT();
        }
        INBT[] values = new INBT[c.size()];
        int s = 0;
        byte commmonId = -1;
        for (Object o : c) {
            values[s] = NBTUtils.toNBT(o);
            if (values[s] == null) continue;
            if (commmonId == -1) {
                commmonId = values[s].func_74732_a();
            } else if (commmonId != values[s].func_74732_a()) {
                commmonId = 0;
            }
            ++s;
        }
        if (commmonId == 3) {
            array = new int[s];
            for (int i = 0; i < s; ++i) {
                array[i] = ((NumberNBT)values[i]).func_150287_d();
            }
            return new IntArrayNBT(array);
        }
        if (commmonId == 1) {
            array = new byte[s];
            for (int i = 0; i < s; ++i) {
                array[i] = ((NumberNBT)values[i]).func_150290_f();
            }
            return new ByteArrayNBT((byte[])array);
        }
        if (commmonId == 4) {
            array = new long[s];
            for (int i = 0; i < s; ++i) {
                array[i] = (int)((NumberNBT)values[i]).func_150291_c();
            }
            return new LongArrayNBT((long[])array);
        }
        if (commmonId == 0 || commmonId == -1) {
            return new ListNBT();
        }
        ListNBT nbt = new ListNBT();
        for (INBT nbt1 : values) {
            if (nbt1 == null) {
                return nbt;
            }
            nbt.add((Object)nbt1);
        }
        return nbt;
    }

    public static void quoteAndEscapeForJS(StringBuilder stringBuilder, String string) {
        int start = stringBuilder.length();
        stringBuilder.append(' ');
        int c = 0;
        for (int i = 0; i < string.length(); ++i) {
            int d = string.charAt(i);
            if (d == 92) {
                stringBuilder.append('\\');
            } else if (d == 34 || d == 39) {
                if (c == 0) {
                    int n = c = d == 39 ? 34 : 39;
                }
                if (c == d) {
                    stringBuilder.append('\\');
                }
            }
            stringBuilder.append((char)d);
        }
        if (c == 0) {
            c = 39;
        }
        stringBuilder.setCharAt(start, (char)c);
        stringBuilder.append((char)c);
    }

    private static INBTType<?> convertType(INBTType<?> tagType) {
        return tagType == CompoundNBT.field_229675_a_ ? COMPOUND_TYPE : (tagType == ListNBT.field_229694_a_ ? LIST_TYPE : tagType);
    }

    @Nullable
    public static OrderedCompoundTag read(PacketBuffer buf) {
        int i = buf.readerIndex();
        byte b = buf.readByte();
        if (b == 0) {
            return null;
        }
        buf.readerIndex(i);
        try {
            DataInputStream stream = new DataInputStream((InputStream)new ByteBufInputStream((ByteBuf)buf));
            byte b1 = stream.readByte();
            if (b1 == 0) {
                return null;
            }
            stream.readUTF();
            INBTType<?> tagType = NBTUtils.convertType(NBTTypes.func_229710_a_((int)b1));
            if (tagType != COMPOUND_TYPE) {
                return null;
            }
            return (OrderedCompoundTag)COMPOUND_TYPE.func_225649_b_((DataInput)stream, 0, NBTSizeTracker.field_152451_a);
        }
        catch (IOException var5) {
            throw new EncoderException((Throwable)var5);
        }
    }
}

