/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.RhinoSecurityManager;
import java.security.AccessController;
import java.security.ProtectionDomain;

public class SecurityUtilities {
    public static String getSystemProperty(String name) {
        return AccessController.doPrivileged(() -> System.getProperty(name));
    }

    public static ProtectionDomain getProtectionDomain(Class<?> clazz) {
        return AccessController.doPrivileged(() -> clazz.getProtectionDomain());
    }

    public static ProtectionDomain getScriptProtectionDomain() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager instanceof RhinoSecurityManager) {
            return AccessController.doPrivileged(() -> {
                Class<?> c = ((RhinoSecurityManager)securityManager).getCurrentScriptClass();
                return c == null ? null : c.getProtectionDomain();
            });
        }
        return null;
    }
}

