/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.BeanProperty;
import dev.latvian.mods.rhino.ClassCache;
import dev.latvian.mods.rhino.ClassShutter;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ContextFactory;
import dev.latvian.mods.rhino.FieldAndMethods;
import dev.latvian.mods.rhino.Kit;
import dev.latvian.mods.rhino.MemberBox;
import dev.latvian.mods.rhino.NativeJavaConstructor;
import dev.latvian.mods.rhino.NativeJavaMethod;
import dev.latvian.mods.rhino.ObjArray;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapForJS;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class JavaMembers {
    private final Class<?> cl;
    private final Map<String, Object> members;
    private Map<String, FieldAndMethods> fieldAndMethods;
    private final Map<String, Object> staticMembers;
    private Map<String, FieldAndMethods> staticFieldAndMethods;
    NativeJavaMethod ctors;

    JavaMembers(Scriptable scope, Class<?> cl) {
        this(scope, cl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaMembers(Scriptable scope, Class<?> cl, boolean includeProtected) {
        try {
            Context cx = ContextFactory.getGlobal().enterContext();
            ClassShutter shutter = cx.getClassShutter();
            if (shutter != null && !shutter.visibleToScripts(cl.getName(), 1)) {
                throw Context.reportRuntimeError1("msg.access.prohibited", cl.getName());
            }
            this.members = new HashMap<String, Object>();
            this.staticMembers = new HashMap<String, Object>();
            this.cl = cl;
            boolean includePrivate = cx.hasFeature(13);
            this.reflect(cx, scope, includeProtected, includePrivate);
        }
        finally {
            Context.exit();
        }
    }

    boolean has(String name, boolean isStatic) {
        Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
        Object obj = ht.get(name);
        if (obj != null) {
            return true;
        }
        return this.findExplicitFunction(name, isStatic) != null;
    }

    Object get(Scriptable scope, String name, Object javaObject, boolean isStatic) {
        Class<?> type;
        Object rval;
        Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
        Object member = ht.get(name);
        if (!isStatic && member == null) {
            member = this.staticMembers.get(name);
        }
        if (member == null && (member = this.getExplicitFunction(scope, name, javaObject, isStatic)) == null) {
            return Scriptable.NOT_FOUND;
        }
        if (member instanceof Scriptable) {
            return member;
        }
        Context cx = Context.getContext();
        try {
            if (member instanceof BeanProperty) {
                BeanProperty bp = (BeanProperty)member;
                if (bp.getter == null) {
                    return Scriptable.NOT_FOUND;
                }
                rval = bp.getter.invoke(javaObject, Context.emptyArgs);
                type = bp.getter.method().getReturnType();
            } else {
                Field field = (Field)member;
                rval = field.get(isStatic ? null : javaObject);
                type = field.getType();
            }
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
        scope = ScriptableObject.getTopLevelScope(scope);
        return cx.getWrapFactory().wrap(cx, scope, rval, type);
    }

    void put(Scriptable scope, String name, Object javaObject, Object value, boolean isStatic) {
        Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
        Object member = ht.get(name);
        if (!isStatic && member == null) {
            member = this.staticMembers.get(name);
        }
        if (member == null) {
            throw this.reportMemberNotFound(name);
        }
        if (member instanceof FieldAndMethods) {
            FieldAndMethods fam = (FieldAndMethods)ht.get(name);
            member = fam.field;
        }
        if (member instanceof BeanProperty) {
            BeanProperty bp = (BeanProperty)member;
            if (bp.setter == null) {
                throw this.reportMemberNotFound(name);
            }
            if (bp.setters == null || value == null) {
                Class<?> setType = bp.setter.argTypes[0];
                Object[] args = new Object[]{Context.jsToJava(value, setType)};
                try {
                    bp.setter.invoke(javaObject, args);
                }
                catch (Exception ex) {
                    throw Context.throwAsScriptRuntimeEx(ex);
                }
            } else {
                Object[] args = new Object[]{value};
                bp.setters.call(Context.getContext(), ScriptableObject.getTopLevelScope(scope), scope, args);
            }
        } else {
            if (!(member instanceof Field)) {
                String str = member == null ? "msg.java.internal.private" : "msg.java.method.assign";
                throw Context.reportRuntimeError1(str, name);
            }
            Field field = (Field)member;
            int fieldModifiers = field.getModifiers();
            if (Modifier.isFinal(fieldModifiers)) {
                throw Context.throwAsScriptRuntimeEx(new IllegalAccessException("Can't modify final field " + field.getName()));
            }
            Object javaValue = Context.jsToJava(value, field.getType());
            try {
                field.set(javaObject, javaValue);
            }
            catch (IllegalAccessException accessEx) {
                throw Context.throwAsScriptRuntimeEx(accessEx);
            }
            catch (IllegalArgumentException argEx) {
                throw Context.reportRuntimeError3("msg.java.internal.field.type", value.getClass().getName(), field, javaObject.getClass().getName());
            }
        }
    }

    Object[] getIds(boolean isStatic) {
        Map<String, Object> map = isStatic ? this.staticMembers : this.members;
        return map.keySet().toArray(new Object[0]);
    }

    static String javaSignature(Class<?> type) {
        if (!type.isArray()) {
            return type.getName();
        }
        int arrayDimension = 0;
        do {
            ++arrayDimension;
        } while ((type = type.getComponentType()).isArray());
        String name = type.getName();
        String suffix = "[]";
        if (arrayDimension == 1) {
            return name.concat(suffix);
        }
        int length = name.length() + arrayDimension * suffix.length();
        StringBuilder sb = new StringBuilder(length);
        sb.append(name);
        while (arrayDimension != 0) {
            --arrayDimension;
            sb.append(suffix);
        }
        return sb.toString();
    }

    static String liveConnectSignature(Class<?>[] argTypes) {
        int N = argTypes.length;
        if (N == 0) {
            return "()";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int i = 0; i != N; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(JavaMembers.javaSignature(argTypes[i]));
        }
        sb.append(')');
        return sb.toString();
    }

    private MemberBox findExplicitFunction(String name, boolean isStatic) {
        boolean isCtor;
        int sigStart = name.indexOf(40);
        if (sigStart < 0) {
            return null;
        }
        Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
        MemberBox[] methodsOrCtors = null;
        boolean bl = isCtor = isStatic && sigStart == 0;
        if (isCtor) {
            methodsOrCtors = this.ctors.methods;
        } else {
            String trueName = name.substring(0, sigStart);
            Object obj = ht.get(trueName);
            if (!isStatic && obj == null) {
                obj = this.staticMembers.get(trueName);
            }
            if (obj instanceof NativeJavaMethod) {
                NativeJavaMethod njm = (NativeJavaMethod)obj;
                methodsOrCtors = njm.methods;
            }
        }
        if (methodsOrCtors != null) {
            for (MemberBox methodsOrCtor : methodsOrCtors) {
                Class<?>[] type = methodsOrCtor.argTypes;
                String sig = JavaMembers.liveConnectSignature(type);
                if (sigStart + sig.length() != name.length() || !name.regionMatches(sigStart, sig, 0, sig.length())) continue;
                return methodsOrCtor;
            }
        }
        return null;
    }

    private Object getExplicitFunction(Scriptable scope, String name, Object javaObject, boolean isStatic) {
        Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
        Object member = null;
        MemberBox methodOrCtor = this.findExplicitFunction(name, isStatic);
        if (methodOrCtor != null) {
            Scriptable prototype = ScriptableObject.getFunctionPrototype(scope);
            if (methodOrCtor.isCtor()) {
                NativeJavaConstructor fun = new NativeJavaConstructor(methodOrCtor);
                fun.setPrototype(prototype);
                member = fun;
                ht.put(name, fun);
            } else {
                String trueName = methodOrCtor.getName();
                member = ht.get(trueName);
                if (member instanceof NativeJavaMethod && ((NativeJavaMethod)member).methods.length > 1) {
                    NativeJavaMethod fun = new NativeJavaMethod(methodOrCtor, name);
                    fun.setPrototype(prototype);
                    ht.put(name, fun);
                    member = fun;
                }
            }
        }
        return member;
    }

    private static Map<MethodSignature, Method> discoverAccessibleMethods(Class<?> clazz, boolean includeProtected, boolean includePrivate) {
        HashMap<MethodSignature, Method> map = new HashMap<MethodSignature, Method>();
        JavaMembers.discoverAccessibleMethods(clazz, map, includeProtected, includePrivate);
        return map;
    }

    private static void discoverAccessibleMethods(Class<?> clazz, Map<MethodSignature, Method> map, boolean includeProtected, boolean includePrivate) {
        Class<?>[] interfaces;
        if ((Modifier.isPublic(clazz.getModifiers()) || includePrivate) && !clazz.isAnnotationPresent(HideFromJS.class)) {
            try {
                if (includeProtected || includePrivate) {
                    while (clazz != null) {
                        try {
                            Method[] methods;
                            for (Method method : methods = clazz.getDeclaredMethods()) {
                                int n;
                                if (method.isAnnotationPresent(HideFromJS.class) || !Modifier.isPublic(n = method.getModifiers()) && !Modifier.isProtected(n) && !includePrivate) continue;
                                if (includePrivate && !method.isAccessible()) {
                                    method.setAccessible(true);
                                }
                                JavaMembers.addMethod(map, method);
                            }
                            Class<?>[] interfaces2 = clazz.getInterfaces();
                            for (GenericDeclaration genericDeclaration : interfaces2) {
                                JavaMembers.discoverAccessibleMethods(genericDeclaration, map, includeProtected, includePrivate);
                            }
                            clazz = clazz.getSuperclass();
                        }
                        catch (SecurityException e) {
                            Method[] methods = clazz.getMethods();
                            for (Method method : methods) {
                                JavaMembers.addMethod(map, method);
                            }
                            break;
                        }
                    }
                } else {
                    Method[] methods;
                    for (Method method : methods = clazz.getMethods()) {
                        JavaMembers.addMethod(map, method);
                    }
                }
                return;
            }
            catch (SecurityException e) {
                Context.reportWarning("Could not discover accessible methods of class " + clazz.getName() + " due to lack of privileges, attemping superclasses/interfaces.");
            }
        }
        for (Class<?> intface : interfaces = clazz.getInterfaces()) {
            JavaMembers.discoverAccessibleMethods(intface, map, includeProtected, includePrivate);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            JavaMembers.discoverAccessibleMethods(superclass, map, includeProtected, includePrivate);
        }
    }

    private static void addMethod(Map<MethodSignature, Method> map, Method method) throws SecurityException {
        MethodSignature sig;
        if (!method.isAnnotationPresent(HideFromJS.class) && !map.containsKey(sig = new MethodSignature(method.getName(), method.getParameterTypes()))) {
            map.put(sig, method);
        }
    }

    private void reflect(Context cx, Scriptable scope, boolean includeProtected, boolean includePrivate) {
        if (this.cl.isAnnotationPresent(HideFromJS.class) || this.cl.getPackage() != null && this.cl.getPackage().isAnnotationPresent(HideFromJS.class)) {
            this.ctors = new NativeJavaMethod(new MemberBox[0], this.cl.getSimpleName());
            return;
        }
        for (Method method : JavaMembers.discoverAccessibleMethods(this.cl, includeProtected, includePrivate).values()) {
            ObjArray overloadedMethods;
            Object value;
            int mods = method.getModifiers();
            boolean isStatic = Modifier.isStatic(mods);
            Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
            String name = method.getName();
            RemapForJS remap = method.getAnnotation(RemapForJS.class);
            if (remap != null) {
                name = remap.value();
            }
            if ((value = ht.get(name)) == null) {
                ht.put(name, method);
                continue;
            }
            if (value instanceof ObjArray) {
                overloadedMethods = (ObjArray)value;
            } else {
                if (!(value instanceof Method)) {
                    Kit.codeBug();
                }
                overloadedMethods = new ObjArray();
                overloadedMethods.add(value);
                ht.put(name, overloadedMethods);
            }
            overloadedMethods.add(method);
        }
        for (int tableCursor = 0; tableCursor != 2; ++tableCursor) {
            boolean isStatic = tableCursor == 0;
            Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
            for (Map.Entry<String, Object> entry : ht.entrySet()) {
                MemberBox[] methodBoxes;
                Object value = entry.getValue();
                if (value instanceof Method) {
                    methodBoxes = new MemberBox[]{new MemberBox((Method)value)};
                } else {
                    ObjArray overloadedMethods = (ObjArray)value;
                    int N = overloadedMethods.size();
                    if (N < 2) {
                        Kit.codeBug();
                    }
                    methodBoxes = new MemberBox[N];
                    for (int i = 0; i != N; ++i) {
                        Method method = (Method)overloadedMethods.get(i);
                        methodBoxes[i] = new MemberBox(method);
                    }
                }
                NativeJavaMethod fun = new NativeJavaMethod(methodBoxes);
                if (scope != null) {
                    ScriptRuntime.setFunctionProtoAndParent(fun, scope);
                }
                ht.put(entry.getKey(), fun);
            }
        }
        for (Field field : this.getAccessibleFields(includeProtected, includePrivate)) {
            String name = field.getName();
            RemapForJS remap = field.getAnnotation(RemapForJS.class);
            if (remap != null) {
                name = remap.value();
            }
            int mods = field.getModifiers();
            try {
                boolean isStatic = Modifier.isStatic(mods);
                Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
                Object member = ht.get(name);
                if (member == null) {
                    ht.put(name, field);
                    continue;
                }
                if (member instanceof NativeJavaMethod) {
                    Map<String, FieldAndMethods> fmht;
                    NativeJavaMethod method = (NativeJavaMethod)member;
                    FieldAndMethods fam = new FieldAndMethods(scope, method.methods, field);
                    Map<String, FieldAndMethods> map = fmht = isStatic ? this.staticFieldAndMethods : this.fieldAndMethods;
                    if (fmht == null) {
                        fmht = new HashMap<String, FieldAndMethods>();
                        if (isStatic) {
                            this.staticFieldAndMethods = fmht;
                        } else {
                            this.fieldAndMethods = fmht;
                        }
                    }
                    fmht.put(name, fam);
                    ht.put(name, fam);
                    continue;
                }
                if (member instanceof Field) {
                    Field oldField = (Field)member;
                    if (!oldField.getDeclaringClass().isAssignableFrom(field.getDeclaringClass())) continue;
                    ht.put(name, field);
                    continue;
                }
                Kit.codeBug();
            }
            catch (SecurityException e) {
                Context.reportWarning("Could not access field " + name + " of class " + this.cl.getName() + " due to lack of privileges.");
            }
        }
        for (int tableCursor = 0; tableCursor != 2; ++tableCursor) {
            boolean isStatic = tableCursor == 0;
            Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
            HashMap<String, BeanProperty> toAdd = new HashMap<String, BeanProperty>();
            for (String name : ht.keySet()) {
                Object member;
                Object v;
                String nameComponent;
                boolean memberIsGetMethod = name.startsWith("get");
                boolean memberIsSetMethod = name.startsWith("set");
                boolean memberIsIsMethod = name.startsWith("is");
                if (!memberIsGetMethod && !memberIsIsMethod && !memberIsSetMethod || (nameComponent = name.substring(memberIsIsMethod ? 2 : 3)).length() == 0) continue;
                String beanPropertyName = nameComponent;
                char ch0 = nameComponent.charAt(0);
                if (Character.isUpperCase(ch0)) {
                    if (nameComponent.length() == 1) {
                        beanPropertyName = nameComponent.toLowerCase();
                    } else {
                        char ch1 = nameComponent.charAt(1);
                        if (!Character.isUpperCase(ch1)) {
                            beanPropertyName = Character.toLowerCase(ch0) + nameComponent.substring(1);
                        }
                    }
                }
                if (toAdd.containsKey(beanPropertyName) || (v = ht.get(beanPropertyName)) != null && (!includePrivate || !(v instanceof Member) || !Modifier.isPrivate(((Member)v).getModifiers()))) continue;
                MemberBox getter = JavaMembers.findGetter(isStatic, ht, "get", nameComponent);
                if (getter == null) {
                    getter = JavaMembers.findGetter(isStatic, ht, "is", nameComponent);
                }
                MemberBox setter = null;
                NativeJavaMethod setters = null;
                String setterName = "set".concat(nameComponent);
                if (ht.containsKey(setterName) && (member = ht.get(setterName)) instanceof NativeJavaMethod) {
                    NativeJavaMethod njmSet = (NativeJavaMethod)member;
                    if (getter != null) {
                        Class<?> type = getter.method().getReturnType();
                        setter = JavaMembers.extractSetMethod(type, njmSet.methods, isStatic);
                    } else {
                        setter = JavaMembers.extractSetMethod(njmSet.methods, isStatic);
                    }
                    if (njmSet.methods.length > 1) {
                        setters = njmSet;
                    }
                }
                BeanProperty bp = new BeanProperty(getter, setter, setters);
                toAdd.put(beanPropertyName, bp);
            }
            ht.putAll(toAdd);
        }
        List<Constructor<?>> constructors = this.getAccessibleConstructors(includePrivate);
        MemberBox[] ctorMembers = new MemberBox[constructors.size()];
        for (int i = 0; i != constructors.size(); ++i) {
            ctorMembers[i] = new MemberBox(constructors.get(i));
        }
        this.ctors = new NativeJavaMethod(ctorMembers, this.cl.getSimpleName());
    }

    private List<Constructor<?>> getAccessibleConstructors(boolean includePrivate) {
        if (this.cl == ScriptRuntime.ClassClass) {
            return Arrays.asList(this.cl.getConstructors());
        }
        ArrayList constructorsList = new ArrayList();
        try {
            for (Constructor<?> c : this.cl.getDeclaredConstructors()) {
                if (c.isAnnotationPresent(HideFromJS.class)) continue;
                if (Modifier.isPublic(c.getModifiers())) {
                    constructorsList.add(c);
                    continue;
                }
                if (!includePrivate) continue;
                c.setAccessible(true);
                constructorsList.add(c);
            }
        }
        catch (SecurityException e) {
            Context.reportWarning("Could not access constructor  of class " + this.cl.getName() + " due to lack of privileges.");
        }
        return constructorsList;
    }

    private List<Field> getAccessibleFields(boolean includeProtected, boolean includePrivate) {
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        try {
            for (Class<?> currentClass = this.cl; currentClass != null; currentClass = currentClass.getSuperclass()) {
                Field[] declared;
                for (Field field : declared = currentClass.getDeclaredFields()) {
                    int mod = field.getModifiers();
                    if (Modifier.isTransient(mod) || !includePrivate && !Modifier.isPublic(mod) && (!includeProtected || !Modifier.isProtected(mod)) || field.isAnnotationPresent(HideFromJS.class)) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    fieldsList.add(field);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return fieldsList;
    }

    private static MemberBox findGetter(boolean isStatic, Map<String, Object> ht, String prefix, String propertyName) {
        Object member;
        String getterName = prefix.concat(propertyName);
        if (ht.containsKey(getterName) && (member = ht.get(getterName)) instanceof NativeJavaMethod) {
            NativeJavaMethod njmGet = (NativeJavaMethod)member;
            return JavaMembers.extractGetMethod(njmGet.methods, isStatic);
        }
        return null;
    }

    private static MemberBox extractGetMethod(MemberBox[] methods, boolean isStatic) {
        for (MemberBox method : methods) {
            if (method.argTypes.length != 0 || isStatic && !method.isStatic()) continue;
            Class<?> type = method.method().getReturnType();
            if (type == Void.TYPE) break;
            return method;
        }
        return null;
    }

    private static MemberBox extractSetMethod(Class<?> type, MemberBox[] methods, boolean isStatic) {
        for (int pass = 1; pass <= 2; ++pass) {
            for (MemberBox method : methods) {
                Class<?>[] params;
                if (isStatic && !method.isStatic() || (params = method.argTypes).length != 1) continue;
                if (pass == 1) {
                    if (params[0] != type) continue;
                    return method;
                }
                if (pass != 2) {
                    Kit.codeBug();
                }
                if (!params[0].isAssignableFrom(type)) continue;
                return method;
            }
        }
        return null;
    }

    private static MemberBox extractSetMethod(MemberBox[] methods, boolean isStatic) {
        for (MemberBox method : methods) {
            if (isStatic && !method.isStatic() || method.method().getReturnType() != Void.TYPE || method.argTypes.length != 1) continue;
            return method;
        }
        return null;
    }

    Map<String, FieldAndMethods> getFieldAndMethodsObjects(Scriptable scope, Object javaObject, boolean isStatic) {
        Map<String, FieldAndMethods> ht;
        Map<String, FieldAndMethods> map = ht = isStatic ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (ht == null) {
            return null;
        }
        int len = ht.size();
        HashMap<String, FieldAndMethods> result = new HashMap<String, FieldAndMethods>(len);
        for (FieldAndMethods fam : ht.values()) {
            FieldAndMethods famNew = new FieldAndMethods(scope, fam.methods, fam.field);
            famNew.javaObject = javaObject;
            result.put(fam.field.getName(), famNew);
        }
        return result;
    }

    static JavaMembers lookupClass(Scriptable scope, Class<?> dynamicType, Class<?> staticType, boolean includeProtected) {
        JavaMembers members;
        ClassCache cache = ClassCache.get(scope);
        Map<Class<?>, JavaMembers> ct = cache.getClassCacheMap();
        Class<?> cl = dynamicType;
        while (true) {
            if ((members = ct.get(cl)) != null) {
                if (cl != dynamicType) {
                    ct.put(dynamicType, members);
                }
                return members;
            }
            try {
                members = new JavaMembers(cache.getAssociatedScope(), cl, includeProtected);
            }
            catch (SecurityException e) {
                if (staticType != null && staticType.isInterface()) {
                    cl = staticType;
                    staticType = null;
                    continue;
                }
                Class<?> parent = cl.getSuperclass();
                if (parent == null) {
                    if (cl.isInterface()) {
                        parent = ScriptRuntime.ObjectClass;
                    } else {
                        throw e;
                    }
                }
                cl = parent;
                continue;
            }
            break;
        }
        if (cache.isCachingEnabled()) {
            ct.put(cl, members);
            if (cl != dynamicType) {
                ct.put(dynamicType, members);
            }
        }
        return members;
    }

    RuntimeException reportMemberNotFound(String memberName) {
        return Context.reportRuntimeError2("msg.java.member.not.found", this.cl.getName(), memberName);
    }

    private static final class MethodSignature {
        private static final Class<?>[] NO_ARGS = new Class[0];
        private final String name;
        private final Class<?>[] args;

        private MethodSignature(String name, Class<?>[] args) {
            this.name = name;
            this.args = args;
        }

        public boolean equals(Object o) {
            if (o instanceof MethodSignature) {
                MethodSignature ms = (MethodSignature)o;
                return ms.name.equals(this.name) && Arrays.equals(this.args, ms.args);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.args.length;
        }
    }
}

