/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.stages;

import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.core.PlayerKJS;
import dev.latvian.kubejs.net.AddStageMessage;
import dev.latvian.kubejs.net.RemoveStageMessage;
import dev.latvian.kubejs.net.SyncStagesMessage;
import dev.latvian.kubejs.stages.NoStages;
import dev.latvian.kubejs.stages.StageChangeEvent;
import dev.latvian.kubejs.stages.StageCreationEvent;
import dev.latvian.kubejs.stages.TagWrapperStages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import me.shedaniel.architectury.event.Event;
import me.shedaniel.architectury.event.EventFactory;
import me.shedaniel.architectury.hooks.PlayerHooks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import org.jetbrains.annotations.Nullable;

public abstract class Stages {
    private static final Event<Consumer<StageCreationEvent>> OVERRIDE_CREATION = EventFactory.createConsumerLoop((Object[])new StageCreationEvent[0]);
    private static final Event<Consumer<StageChangeEvent>> ADDED = EventFactory.createConsumerLoop((Object[])new StageChangeEvent[0]);
    private static final Event<Consumer<StageChangeEvent>> REMOVED = EventFactory.createConsumerLoop((Object[])new StageChangeEvent[0]);
    public final PlayerEntity player;

    private static Stages createEntityStages(PlayerEntity player) {
        if (PlayerHooks.isFake((PlayerEntity)player) || KubeJS.PROXY.isClientButNotSelf(player)) {
            return NoStages.NULL_INSTANCE;
        }
        StageCreationEvent event = new StageCreationEvent(player);
        ((Consumer)OVERRIDE_CREATION.invoker()).accept(event);
        if (event.getPlayerStages() != null) {
            return event.getPlayerStages();
        }
        return new TagWrapperStages(player);
    }

    public static void overrideCreation(Consumer<StageCreationEvent> event) {
        OVERRIDE_CREATION.register(event);
    }

    public static void added(Consumer<StageChangeEvent> event) {
        ADDED.register(event);
    }

    public static void invokeAdded(Stages stages, String stage) {
        ((Consumer)ADDED.invoker()).accept(new StageChangeEvent(stages, stage));
    }

    public static void removed(Consumer<StageChangeEvent> event) {
        REMOVED.register(event);
    }

    public static void invokeRemoved(Stages stages, String stage) {
        ((Consumer)REMOVED.invoker()).accept(new StageChangeEvent(stages, stage));
    }

    public static Stages get(@Nullable PlayerEntity player) {
        if (player == null) {
            return NoStages.NULL_INSTANCE;
        }
        Stages stages = ((PlayerKJS)player).getStagesRawKJS();
        if (stages == null) {
            stages = Stages.createEntityStages(player);
            ((PlayerKJS)player).setStagesKJS(stages);
        }
        return stages;
    }

    public Stages(PlayerEntity p) {
        this.player = p;
    }

    public abstract boolean addNoUpdate(String var1);

    public abstract boolean removeNoUpdate(String var1);

    public abstract Collection<String> getAll();

    public boolean has(String stage) {
        return this.getAll().contains(stage);
    }

    @Deprecated
    public final Collection<String> getList() {
        return this.getAll();
    }

    public boolean add(String stage) {
        if (this.addNoUpdate(stage)) {
            if (this.player instanceof ServerPlayerEntity) {
                new AddStageMessage(this.player.func_110124_au(), stage).sendToAll(((ServerPlayerEntity)this.player).field_71133_b);
            }
            Stages.invokeAdded(this, stage);
            return true;
        }
        return false;
    }

    public boolean remove(String stage) {
        if (this.removeNoUpdate(stage)) {
            if (this.player instanceof ServerPlayerEntity) {
                new RemoveStageMessage(this.player.func_110124_au(), stage).sendToAll(((ServerPlayerEntity)this.player).field_71133_b);
            }
            Stages.invokeRemoved(this, stage);
            return true;
        }
        return false;
    }

    public final boolean set(String stage, boolean enabled) {
        return enabled ? this.add(stage) : this.remove(stage);
    }

    public final boolean toggle(String stage) {
        return this.set(stage, !this.has(stage));
    }

    public boolean clear() {
        Collection<String> all = this.getAll();
        if (all.isEmpty()) {
            return false;
        }
        for (String s : new ArrayList<String>(all)) {
            this.remove(s);
        }
        return true;
    }

    public void sync() {
        if (this.player instanceof ServerPlayerEntity) {
            new SyncStagesMessage(this.player.func_110124_au(), this.getAll()).sendToAll(((ServerPlayerEntity)this.player).field_71133_b);
        }
    }

    public void replace(Collection<String> stages) {
        Collection<String> all = this.getAll();
        for (String s : new ArrayList<String>(all)) {
            this.removeNoUpdate(s);
        }
        for (String s : stages) {
            this.addNoUpdate(s);
        }
    }
}

