/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.script;

import com.mojang.serialization.Codec;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.architectury.registry.Registry;
import net.minecraft.item.Item;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;

public class RegistryTypeWrapperFactory<T>
implements TypeWrapperFactory<T> {
    private static List<RegistryTypeWrapperFactory<?>> all;
    public final Class<T> type;
    public final Registry<T> registry;
    public final String name;

    public static List<RegistryTypeWrapperFactory<?>> getAll() {
        if (all == null) {
            all = new ArrayList();
            try {
                for (Field field : net.minecraft.util.registry.Registry.class.getDeclaredFields()) {
                    if (field.getType() != RegistryKey.class || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
                    String id = "unknown";
                    try {
                        field.setAccessible(true);
                        RegistryKey key = (RegistryKey)field.get(null);
                        id = key.func_240901_a_().func_110623_a();
                        Type type = field.getGenericType();
                        Type type1 = ((ParameterizedType)type).getActualTypeArguments()[0];
                        Type type2 = ((ParameterizedType)type1).getActualTypeArguments()[0];
                        Class<?> rawType = UtilsJS.getRawType(type2);
                        if (rawType == Item.class || rawType == ResourceLocation.class || rawType == RegistryKey.class || rawType == Codec.class) continue;
                        all.add(new RegistryTypeWrapperFactory(rawType, KubeJSRegistries.genericRegistry(key), key.func_240901_a_().toString()));
                    }
                    catch (Throwable t) {
                        KubeJS.LOGGER.error("Failed to create TypeWrapper for registry " + id + ": " + t);
                    }
                }
            }
            catch (Exception ex) {
                KubeJS.LOGGER.error("Failed to register TypeWrappers for registries!");
                ex.printStackTrace();
            }
        }
        return all;
    }

    private RegistryTypeWrapperFactory(Class<T> t, Registry<T> r, String n) {
        this.type = t;
        this.registry = r;
        this.name = n;
    }

    public T wrap(Object o) {
        if (o == null) {
            return null;
        }
        if (this.type.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        return (T)this.registry.get(UtilsJS.getMCID(o));
    }

    public String toString() {
        return "RegistryTypeWrapperFactory{type=" + this.type.getName() + ", registry=" + this.name + '}';
    }
}

