/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe.special;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.latvian.kubejs.recipe.KubeJSRecipeEventHandler;
import dev.latvian.kubejs.recipe.ingredientaction.IngredientAction;
import java.util.List;
import me.shedaniel.architectury.core.AbstractRecipeSerializer;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShapelessKubeJSRecipe
extends ShapelessRecipe {
    private String group;
    private ItemStack result;
    private NonNullList<Ingredient> ingredients;
    private List<IngredientAction> ingredientActions;

    public ShapelessKubeJSRecipe(ResourceLocation _id) {
        super(_id, "", ItemStack.field_190927_a, NonNullList.func_191197_a((int)0, (Object)Ingredient.field_193370_a));
    }

    public IRecipeSerializer<?> func_199559_b() {
        return KubeJSRecipeEventHandler.SHAPELESS.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_193358_e() {
        return this.group;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public boolean func_77569_a(CraftingInventory craftingContainer, World level) {
        RecipeItemHelper stackedContents = new RecipeItemHelper();
        int count = 0;
        for (int i = 0; i < craftingContainer.func_70302_i_(); ++i) {
            ItemStack stack = craftingContainer.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            ++count;
            stackedContents.func_221264_a(stack, 1);
        }
        return count == this.ingredients.size() && stackedContents.func_194116_a((IRecipe)this, null);
    }

    public ItemStack func_77572_b(CraftingInventory craftingContainer) {
        return this.result.func_77946_l();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_194133_a(int w, int h) {
        return w * h >= this.ingredients.size();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory container) {
        NonNullList list = NonNullList.func_191197_a((int)container.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, (Object)IngredientAction.getRemaining(container, i, this.ingredientActions));
        }
        return list;
    }

    public static class SerializerKJS
    extends AbstractRecipeSerializer<ShapelessKubeJSRecipe> {
        public ShapelessKubeJSRecipe fromJson(ResourceLocation id, JsonObject json) {
            ShapelessKubeJSRecipe r = new ShapelessKubeJSRecipe(id);
            r.group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            r.ingredients = SerializerKJS.itemsFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (r.ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (r.ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            r.result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            r.ingredientActions = IngredientAction.parseList(json.get("kubejs_actions"));
            return r;
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray a) {
            NonNullList list = NonNullList.func_191196_a();
            for (int i = 0; i < a.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)a.get(i));
                if (ingredient.func_203189_d()) continue;
                list.add((Object)ingredient);
            }
            return list;
        }

        public ShapelessKubeJSRecipe fromNetwork(ResourceLocation id, PacketBuffer buf) {
            ShapelessKubeJSRecipe r = new ShapelessKubeJSRecipe(id);
            r.group = buf.func_150789_c(Short.MAX_VALUE);
            int s = buf.func_150792_a();
            r.ingredients = NonNullList.func_191197_a((int)s, (Object)Ingredient.field_193370_a);
            for (int i = 0; i < s; ++i) {
                r.ingredients.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buf));
            }
            r.result = buf.func_150791_c();
            r.ingredientActions = IngredientAction.readList(buf);
            return r;
        }

        public void toNetwork(PacketBuffer buf, ShapelessKubeJSRecipe r) {
            buf.func_180714_a(r.group);
            buf.func_150787_b(r.ingredients.size());
            for (Ingredient ingredient : r.ingredients) {
                ingredient.func_199564_a(buf);
            }
            buf.func_150788_a(r.result);
            IngredientAction.writeList(buf, r.ingredientActions);
        }
    }
}

