/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe.mod;

import com.google.gson.JsonObject;
import dev.latvian.kubejs.recipe.RecipeJS;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;

public class TechRebornCompat {
    private static final Map<Class, MethodHandle> TR_CONSTRUCTORS = new ConcurrentHashMap<Class, MethodHandle>();
    private static final Map<Class, MethodHandle> TR_DESERIALIZERS = new ConcurrentHashMap<Class, MethodHandle>();

    public static MethodHandle getTRRecipeConstructor(IRecipe<?> resultRecipe, RecipeJS recipe) throws NoSuchMethodException, IllegalAccessException {
        Class<?> recipeClass = resultRecipe.getClass();
        MethodHandle handle = TR_CONSTRUCTORS.get(recipeClass);
        if (handle != null) {
            return handle;
        }
        handle = MethodHandles.lookup().findConstructor(recipeClass, MethodType.methodType(Void.TYPE, recipe.type.serializer.getClass(), ResourceLocation.class));
        TR_CONSTRUCTORS.put(recipeClass, handle);
        return handle;
    }

    public static MethodHandle getTRRecipeSerializer(IRecipe<?> resultRecipe) throws NoSuchMethodException, IllegalAccessException {
        Class<?> recipeClass = resultRecipe.getClass();
        MethodHandle handle = TR_DESERIALIZERS.get(recipeClass);
        if (handle != null) {
            return handle;
        }
        handle = MethodHandles.lookup().findVirtual(resultRecipe.getClass(), "deserialize", MethodType.methodType(Void.TYPE, JsonObject.class));
        TR_DESERIALIZERS.put(recipeClass, handle);
        return handle;
    }
}

