/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe.minecraft;

import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.util.ListJS;
import me.shedaniel.architectury.platform.Platform;

public class CookingRecipeJS
extends RecipeJS {
    @Override
    public void create(ListJS args) {
        this.outputItems.add(this.parseResultItem(args.get(0)));
        this.inputItems.add(this.parseIngredientItem(args.get(1)));
        if (args.size() >= 3) {
            this.xp(((Number)args.get(2)).floatValue());
        }
        if (args.size() >= 4) {
            this.cookingTime(((Number)args.get(3)).intValue());
        }
    }

    @Override
    public void deserialize() {
        this.outputItems.add(this.parseResultItem(this.json.get("result")));
        this.inputItems.add(this.parseIngredientItem(this.json.get("ingredient")));
    }

    @Override
    public void serialize() {
        if (this.serializeOutputs) {
            if (Platform.isForge()) {
                this.json.add("result", ((ItemStackJS)this.outputItems.get(0)).toResultJson());
            } else {
                this.json.addProperty("result", ((ItemStackJS)this.outputItems.get(0)).getId());
            }
        }
        if (this.serializeInputs) {
            this.json.add("ingredient", ((IngredientJS)this.inputItems.get(0)).toJson());
        }
    }

    public CookingRecipeJS xp(float xp) {
        this.json.addProperty("experience", (Number)Float.valueOf(Math.max(0.0f, xp)));
        return this;
    }

    public CookingRecipeJS cookingTime(int time) {
        this.json.addProperty("cookingtime", (Number)Math.max(0, time));
        return this;
    }
}

