/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.integration.jei;

import dev.latvian.kubejs.BuiltinKubeJSPlugin;
import dev.latvian.kubejs.fluid.FluidStackJS;
import dev.latvian.kubejs.integration.jei.AddJEIEventJS;
import dev.latvian.kubejs.integration.jei.HideCustomJEIEventJS;
import dev.latvian.kubejs.integration.jei.HideJEIEventJS;
import dev.latvian.kubejs.integration.jei.InformationJEIEventJS;
import dev.latvian.kubejs.integration.jei.JEISubtypesEventJS;
import dev.latvian.kubejs.integration.jei.RemoveJEICategoriesEvent;
import dev.latvian.kubejs.integration.jei.RemoveJEIRecipesEvent;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.script.ScriptType;
import java.util.ArrayList;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = new ResourceLocation("kubejs", "jei");
    public IJeiRuntime runtime;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void onRuntimeAvailable(IJeiRuntime r) {
        this.runtime = r;
        BuiltinKubeJSPlugin.GLOBAL.put("jeiRuntime", this.runtime);
        new HideJEIEventJS<ItemStack>(this.runtime, VanillaTypes.ITEM, object -> IngredientJS.of(object)::testVanilla, stack -> !stack.func_190926_b()).post(ScriptType.CLIENT, "jei.hide.items");
        new HideJEIEventJS<FluidStack>(this.runtime, VanillaTypes.FLUID, object -> {
            FluidStackJS fs = FluidStackJS.of(object);
            return fluidStack -> fluidStack.getFluid().func_207187_a(fs.getFluid()) && Objects.equals(fluidStack.getTag(), fs.getNbt());
        }, stack -> !stack.isEmpty()).post(ScriptType.CLIENT, "jei.hide.fluids");
        new HideCustomJEIEventJS(this.runtime).post(ScriptType.CLIENT, "jei.hide.custom");
        new RemoveJEICategoriesEvent(this.runtime).post(ScriptType.CLIENT, "jei.remove.categories");
        new RemoveJEIRecipesEvent(this.runtime).post(ScriptType.CLIENT, "jei.remove.recipes");
        new AddJEIEventJS<ItemStack>(this.runtime, VanillaTypes.ITEM, object -> ItemStackJS.of(object).getItemStack(), stack -> !stack.func_190926_b()).post(ScriptType.CLIENT, "jei.add.items");
        new AddJEIEventJS<FluidStack>(this.runtime, VanillaTypes.FLUID, object -> this.fromArchitectury(FluidStackJS.of(object).getFluidStack()), stack -> !stack.isEmpty()).post(ScriptType.CLIENT, "jei.add.fluids");
    }

    private FluidStack fromArchitectury(me.shedaniel.architectury.fluid.FluidStack stack) {
        return new FluidStack(stack.getFluid(), stack.getAmount().intValue(), stack.getTag());
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        new JEISubtypesEventJS(registration).post(ScriptType.CLIENT, "jei.subtypes");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList list = new ArrayList();
        new InformationJEIEventJS(registration.getIngredientManager(), list).post(ScriptType.CLIENT, "jei.information");
        registration.addRecipes(list, VanillaRecipeCategoryUid.INFORMATION);
    }
}

