/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.entity;

import dev.latvian.kubejs.entity.EntitySpawnedEventJS;
import dev.latvian.kubejs.entity.LivingEntityAttackEventJS;
import dev.latvian.kubejs.entity.LivingEntityDeathEventJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.ServerJS;
import me.shedaniel.architectury.event.events.EntityEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class KubeJSEntityEventHandler {
    public static void init() {
        EntityEvent.LIVING_DEATH.register(KubeJSEntityEventHandler::livingDeath);
        EntityEvent.LIVING_ATTACK.register(KubeJSEntityEventHandler::livingAttack);
        EntityEvent.ADD.register(KubeJSEntityEventHandler::entitySpawned);
    }

    private static ActionResultType livingDeath(LivingEntity entity, DamageSource source) {
        if (entity != null && new LivingEntityDeathEventJS(entity, source).post("entity.death")) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    private static ActionResultType livingAttack(LivingEntity entity, DamageSource source, float amount) {
        if (entity != null && amount > 0.0f && new LivingEntityAttackEventJS(entity, source, amount).post("entity.attack")) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    private static ActionResultType entitySpawned(Entity entity, World world) {
        if (entity != null && ServerJS.instance != null && ServerJS.instance.overworld != null && !world.func_201670_d() && new EntitySpawnedEventJS(entity, world).post(ScriptType.SERVER, "entity.spawned")) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }
}

