/*
 * Decompiled with CFR 0.152.
 */
package com.mcwlights.kikoz.objects;

import com.mcwlights.kikoz.objects.LightSlab;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TorchObject
extends LightSlab {
    protected final IParticleData flame;
    protected static final VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);
    protected static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0);
    protected static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)6.0);

    public TorchObject(AbstractBlock.Properties properties, IParticleData flame) {
        super(properties);
        this.flame = flame;
    }

    public boolean canSurvive(BlockState state, World world, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)field_185512_D);
        BlockPos offsetPos = pos.func_177972_a(direction.func_176734_d());
        BlockState offsetState = world.func_180495_p(offsetPos);
        return TorchObject.func_220185_b((IWorldReader)world, (BlockPos)offsetPos, (Direction)direction) && state.func_177229_b((Property)field_196366_M) != AttachFace.CEILING;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)field_185512_D);
        AttachFace face = (AttachFace)state.func_177229_b((Property)field_196366_M);
        switch (face) {
            case FLOOR: {
                return BOTTOM_SHAPE;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return EAST_SHAPE;
                    }
                    case WEST: {
                        return WEST_SHAPE;
                    }
                    case SOUTH: {
                        return SOUTH_SHAPE;
                    }
                    case NORTH: {
                        return NORTH_SHAPE;
                    }
                    case UP: 
                    case DOWN: {
                        return BOTTOM_SHAPE;
                    }
                }
                break;
            }
            case CEILING: {
                return TOP_SHAPE;
            }
        }
        return super.func_220053_a(state, world, pos, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        Direction direction = (Direction)state.func_177229_b((Property)field_185512_D);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.7;
        double d2 = (double)pos.func_177952_p() + 0.5;
        double d3 = 0.22;
        double d4 = 0.27;
        Direction direction1 = direction.func_176734_d();
        switch ((AttachFace)state.func_177229_b((Property)field_196366_M)) {
            case FLOOR: {
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0.0, 0.0, 0.0);
                world.func_195594_a(this.flame, d0, d1, d2, 0.0, 0.0, 0.0);
                break;
            }
            case WALL: {
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + 0.27 * (double)direction1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)direction1.func_82599_e(), 0.0, 0.0, 0.0);
                world.func_195594_a(this.flame, d0 + 0.27 * (double)direction1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)direction1.func_82599_e(), 0.0, 0.0, 0.0);
                break;
            }
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (world.field_72995_K) {
            return;
        }
        if (state.func_177229_b((Property)field_196366_M) == AttachFace.WALL && !TorchObject.func_220185_b((IWorldReader)world, (BlockPos)pos, (Direction)((Direction)state.func_177229_b((Property)field_185512_D)))) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }
}

