/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.ImmutableBiMap;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.to_server.KeyPressPKT;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.text.PELang;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="projecte", value={Dist.CLIENT})
public class ClientKeyHelper {
    private static ImmutableBiMap<KeyBinding, PEKeybind> mcToPe = ImmutableBiMap.of();
    private static ImmutableBiMap<PEKeybind, KeyBinding> peToMc = ImmutableBiMap.of();

    @SubscribeEvent
    public static void keyPress(TickEvent.ClientTickEvent event) {
        for (KeyBinding k : mcToPe.keySet()) {
            while (k.func_151468_f()) {
                PacketHandler.sendToServer(new KeyPressPKT((PEKeybind)mcToPe.get((Object)k)));
            }
        }
    }

    public static void registerKeyBindings() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        ClientKeyHelper.addKeyBinding((ImmutableBiMap.Builder<KeyBinding, PEKeybind>)builder, PEKeybind.HELMET_TOGGLE, KeyModifier.SHIFT, 88);
        ClientKeyHelper.addKeyBinding((ImmutableBiMap.Builder<KeyBinding, PEKeybind>)builder, PEKeybind.BOOTS_TOGGLE, KeyModifier.NONE, 88);
        ClientKeyHelper.addKeyBinding((ImmutableBiMap.Builder<KeyBinding, PEKeybind>)builder, PEKeybind.CHARGE, KeyModifier.NONE, 86);
        ClientKeyHelper.addKeyBinding((ImmutableBiMap.Builder<KeyBinding, PEKeybind>)builder, PEKeybind.EXTRA_FUNCTION, KeyModifier.NONE, 67);
        ClientKeyHelper.addKeyBinding((ImmutableBiMap.Builder<KeyBinding, PEKeybind>)builder, PEKeybind.FIRE_PROJECTILE, KeyModifier.NONE, 82);
        ClientKeyHelper.addKeyBinding((ImmutableBiMap.Builder<KeyBinding, PEKeybind>)builder, PEKeybind.MODE, KeyModifier.NONE, 71);
        mcToPe = builder.build();
        peToMc = mcToPe.inverse();
        for (KeyBinding k : mcToPe.keySet()) {
            ClientRegistry.registerKeyBinding((KeyBinding)k);
        }
    }

    private static void addKeyBinding(ImmutableBiMap.Builder<KeyBinding, PEKeybind> builder, PEKeybind keyBind, KeyModifier modifier, int keyCode) {
        builder.put((Object)new KeyBinding(keyBind.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, modifier, InputMappings.Type.KEYSYM, keyCode, PELang.PROJECTE.getTranslationKey()), (Object)keyBind);
    }

    public static ITextComponent getKeyName(PEKeybind k) {
        if (peToMc.containsKey((Object)k)) {
            return ((KeyBinding)peToMc.get((Object)k)).func_238171_j_();
        }
        return TextComponentUtil.build(k);
    }
}

