/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nbt.INBTProcessor;
import moze_intel.projecte.api.nbt.NBTProcessor;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class AnnotationHelper {
    private static final Type MAPPER_TYPE = Type.getType(EMCMapper.class);
    private static final Type RECIPE_TYPE_MAPPER_TYPE = Type.getType(RecipeTypeMapper.class);
    private static final Type NBT_PROCESSOR_TYPE = Type.getType(NBTProcessor.class);

    public static List<INBTProcessor> getNBTProcessors() {
        ModList modList = ModList.get();
        ArrayList<INBTProcessor> nbtProcessors = new ArrayList<INBTProcessor>();
        HashMap<INBTProcessor, Integer> priorities = new HashMap<INBTProcessor, Integer>();
        for (ModFileScanData scanData : modList.getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                INBTProcessor processor;
                if (!NBT_PROCESSOR_TYPE.equals((Object)data.getAnnotationType()) || !AnnotationHelper.checkRequiredMods(data) || (processor = AnnotationHelper.getNBTProcessor(data.getMemberName())) == null) continue;
                int priority = AnnotationHelper.getPriority(data);
                nbtProcessors.add(processor);
                priorities.put(processor, priority);
                PECore.LOGGER.info("Found and loaded NBT Processor: {}, with priority {}", (Object)processor.getName(), (Object)priority);
            }
        }
        nbtProcessors.sort(Collections.reverseOrder(Comparator.comparing(priorities::get)));
        return nbtProcessors;
    }

    public static List<IRecipeTypeMapper> getRecipeTypeMappers() {
        ModList modList = ModList.get();
        ArrayList<IRecipeTypeMapper> recipeTypeMappers = new ArrayList<IRecipeTypeMapper>();
        HashMap<IRecipeTypeMapper, Integer> priorities = new HashMap<IRecipeTypeMapper, Integer>();
        for (ModFileScanData scanData : modList.getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                IRecipeTypeMapper mapper;
                if (!RECIPE_TYPE_MAPPER_TYPE.equals((Object)data.getAnnotationType()) || !AnnotationHelper.checkRequiredMods(data) || (mapper = AnnotationHelper.getRecipeTypeMapper(data.getMemberName())) == null) continue;
                int priority = AnnotationHelper.getPriority(data);
                recipeTypeMappers.add(mapper);
                priorities.put(mapper, priority);
                PECore.LOGGER.info("Found and loaded RecipeType Mapper: {}, with priority {}", (Object)mapper.getName(), (Object)priority);
            }
        }
        recipeTypeMappers.sort(Collections.reverseOrder(Comparator.comparing(priorities::get)));
        return recipeTypeMappers;
    }

    public static List<IEMCMapper<NormalizedSimpleStack, Long>> getEMCMappers() {
        ModList modList = ModList.get();
        ArrayList<IEMCMapper<NormalizedSimpleStack, Long>> emcMappers = new ArrayList<IEMCMapper<NormalizedSimpleStack, Long>>();
        HashMap priorities = new HashMap();
        for (ModFileScanData scanData : modList.getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                IEMCMapper<?, ?> mapper;
                if (!MAPPER_TYPE.equals((Object)data.getAnnotationType()) || !AnnotationHelper.checkRequiredMods(data) || (mapper = AnnotationHelper.getEMCMapper(data.getMemberName())) == null) continue;
                try {
                    IEMCMapper<?, ?> emcMapper = mapper;
                    int priority = AnnotationHelper.getPriority(data);
                    emcMappers.add(emcMapper);
                    priorities.put(emcMapper, priority);
                    PECore.LOGGER.info("Found and loaded EMC mapper: {}, with priority {}", (Object)mapper.getName(), (Object)priority);
                }
                catch (ClassCastException e) {
                    PECore.LOGGER.error("{}: Is not a mapper for {}, to {}", mapper.getClass(), NormalizedSimpleStack.class, Long.class, (Object)e);
                }
            }
        }
        emcMappers.sort(Collections.reverseOrder(Comparator.comparing(priorities::get)));
        return emcMappers;
    }

    @Nullable
    private static IEMCMapper<?, ?> getEMCMapper(String className) {
        return AnnotationHelper.createOrGetInstance(className, IEMCMapper.class, EMCMapper.Instance.class, IEMCMapper::getName);
    }

    @Nullable
    private static IRecipeTypeMapper getRecipeTypeMapper(String className) {
        return AnnotationHelper.createOrGetInstance(className, IRecipeTypeMapper.class, RecipeTypeMapper.Instance.class, IRecipeTypeMapper::getName);
    }

    @Nullable
    private static INBTProcessor getNBTProcessor(String className) {
        return AnnotationHelper.createOrGetInstance(className, INBTProcessor.class, NBTProcessor.Instance.class, INBTProcessor::getName);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private static <T> T createOrGetInstance(String className, Class<T> baseClass, Class<? extends Annotation> instanceAnnotation, Function<T, String> nameFunction) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean checkRequiredMods(ModFileScanData.AnnotationData data) {
        List requiredMods;
        Map annotationData = data.getAnnotationData();
        if (annotationData.containsKey("requiredMods") && (requiredMods = (List)annotationData.get("requiredMods")).stream().anyMatch(modid -> !ModList.get().isLoaded(modid))) {
            PECore.debugLog("Skipped checking class {}, as its required mods ({}) are not loaded.", data.getMemberName(), Arrays.toString(requiredMods.toArray()));
            return false;
        }
        return true;
    }

    private static int getPriority(ModFileScanData.AnnotationData data) {
        Map annotationData = data.getAnnotationData();
        if (annotationData.containsKey("priority")) {
            return (Integer)annotationData.get("priority");
        }
        return 0;
    }
}

