/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.gameObjs.container.AlchBagContainer;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.impl.capability.AlchBagImpl;
import moze_intel.projecte.network.commands.argument.ColorArgument;
import moze_intel.projecte.network.commands.argument.UUIDArgument;
import moze_intel.projecte.utils.text.PELang;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ShowBagCMD {
    private static final SimpleCommandExceptionType NOT_FOUND = new SimpleCommandExceptionType((Message)PELang.SHOWBAG_NOT_FOUND.translate(new Object[0]));

    public static LiteralArgumentBuilder<CommandSource> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"showbag").requires(cs -> cs.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"color", (ArgumentType)new ColorArgument()).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> ShowBagCMD.showBag((CommandContext<CommandSource>)ctx, ColorArgument.getColor(ctx, "color"), EntityArgument.func_197089_d((CommandContext)ctx, (String)"target"))))).then(Commands.func_197056_a((String)"uuid", (ArgumentType)new UUIDArgument()).executes(ctx -> ShowBagCMD.showBag((CommandContext<CommandSource>)ctx, ColorArgument.getColor(ctx, "color"), UUIDArgument.getUUID(ctx, "uuid")))));
    }

    private static int showBag(CommandContext<CommandSource> ctx, DyeColor color, ServerPlayerEntity player) throws CommandSyntaxException {
        ServerPlayerEntity senderPlayer = ((CommandSource)ctx.getSource()).func_197035_h();
        return ShowBagCMD.showBag(senderPlayer, ShowBagCMD.createContainer(senderPlayer, player, color));
    }

    private static int showBag(CommandContext<CommandSource> ctx, DyeColor color, UUID uuid) throws CommandSyntaxException {
        ServerPlayerEntity senderPlayer = ((CommandSource)ctx.getSource()).func_197035_h();
        return ShowBagCMD.showBag(senderPlayer, ShowBagCMD.createContainer(senderPlayer, uuid, color));
    }

    private static int showBag(ServerPlayerEntity senderPlayer, INamedContainerProvider container) {
        NetworkHooks.openGui((ServerPlayerEntity)senderPlayer, (INamedContainerProvider)container, b -> {
            b.writeBoolean(false);
            b.writeBoolean(false);
        });
        return 1;
    }

    private static INamedContainerProvider createContainer(ServerPlayerEntity sender, ServerPlayerEntity target, DyeColor color) {
        IItemHandlerModifiable inv = (IItemHandlerModifiable)((IAlchBagProvider)target.getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY).orElseThrow(NullPointerException::new)).getBag(color);
        TranslationTextComponent name = PELang.SHOWBAG_NAMED.translate(new Object[]{PEItems.getBag(color), target.func_145748_c_()});
        return ShowBagCMD.getContainer(sender, (ITextComponent)name, inv, false, () -> target.func_70089_S() && !target.func_193105_t());
    }

    private static INamedContainerProvider createContainer(ServerPlayerEntity sender, UUID target, DyeColor color) throws CommandSyntaxException {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        IItemHandlerModifiable inv = ShowBagCMD.loadOfflineBag(server, target, color);
        GameProfile profileByUUID = server.func_152358_ax().func_152652_a(target);
        Object name = profileByUUID == null ? TextComponentUtil.build(new Object[]{PEItems.getBag(color)}) : PELang.SHOWBAG_NAMED.translate(new Object[]{PEItems.getBag(color), profileByUUID.getName()});
        return ShowBagCMD.getContainer(sender, (ITextComponent)name, inv, true, () -> true);
    }

    private static INamedContainerProvider getContainer(final ServerPlayerEntity sender, final ITextComponent name, final IItemHandlerModifiable inv, final boolean immutable, final BooleanSupplier canInteractWith) {
        return new INamedContainerProvider(){

            @Nonnull
            public ITextComponent func_145748_c_() {
                return name;
            }

            public Container createMenu(int windowId, @Nonnull PlayerInventory playerInv, @Nonnull PlayerEntity player) {
                return new AlchBagContainer(windowId, sender.field_71071_by, Hand.OFF_HAND, inv, 0, immutable){

                    @Override
                    public boolean func_75145_c(@Nonnull PlayerEntity player) {
                        return canInteractWith.getAsBoolean();
                    }
                };
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IItemHandlerModifiable loadOfflineBag(MinecraftServer server, UUID playerUUID, DyeColor color) throws CommandSyntaxException {
        File playerData = server.func_240776_a_(FolderName.field_237247_c_).toFile();
        if (!playerData.exists()) throw NOT_FOUND.create();
        File player = new File(playerData, playerUUID.toString() + ".dat");
        if (!player.exists()) throw NOT_FOUND.create();
        if (!player.isFile()) throw NOT_FOUND.create();
        try (FileInputStream in = new FileInputStream(player);){
            CompoundNBT playerDat = CompressedStreamTools.func_74796_a((InputStream)in);
            CompoundNBT bagProvider = playerDat.func_74775_l("ForgeCaps").func_74775_l(AlchBagImpl.Provider.NAME.toString());
            IAlchBagProvider provider = (IAlchBagProvider)ProjectEAPI.ALCH_BAG_CAPABILITY.getDefaultInstance();
            ProjectEAPI.ALCH_BAG_CAPABILITY.readNBT((Object)provider, null, (INBT)bagProvider);
            IItemHandlerModifiable iItemHandlerModifiable = (IItemHandlerModifiable)provider.getBag(color);
            return iItemHandlerModifiable;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw NOT_FOUND.create();
    }
}

