/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.handlers;

import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.capability.managing.BasicCapabilityResolver;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class CommonInternalAbilities {
    @CapabilityInject(value=CommonInternalAbilities.class)
    public static Capability<CommonInternalAbilities> CAPABILITY = null;
    public static final ResourceLocation NAME = PECore.rl("common_internal_abilities");
    private static final AttributeModifier WATER_SPEED_BOOST = new AttributeModifier("Walk on water speed boost", 0.15, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier LAVA_SPEED_BOOST = new AttributeModifier("Walk on lava speed boost", 0.15, AttributeModifier.Operation.ADDITION);
    private final PlayerEntity player;

    public CommonInternalAbilities(PlayerEntity player) {
        this.player = player;
    }

    public void tick() {
        ModifiableAttributeInstance attribute;
        boolean applyWaterSpeed = false;
        boolean applyLavaSpeed = false;
        WalkOnType waterWalkOnType = this.canWalkOnWater();
        WalkOnType lavaWalkOnType = this.canWalkOnLava();
        if (waterWalkOnType.canWalk() || lavaWalkOnType.canWalk()) {
            boolean lava;
            int x = (int)Math.floor(this.player.func_226277_ct_());
            int y = (int)(this.player.func_226278_cu_() - this.player.func_70033_W());
            int z = (int)Math.floor(this.player.func_226281_cx_());
            BlockPos pos = new BlockPos(x, y, z);
            FluidState below = this.player.field_70170_p.func_204610_c(pos.func_177977_b());
            boolean water = waterWalkOnType.canWalk() && below.func_206884_a((ITag)FluidTags.field_206959_a);
            boolean bl = lava = lavaWalkOnType.canWalk() && below.func_206884_a((ITag)FluidTags.field_206960_b);
            if ((water || lava) && this.player.field_70170_p.func_175623_d(pos)) {
                if (!this.player.func_225608_bj_()) {
                    this.player.func_213317_d(this.player.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
                    this.player.field_70143_R = 0.0f;
                    this.player.func_230245_c_(true);
                }
                applyWaterSpeed = water && waterWalkOnType == WalkOnType.ABLE_WITH_SPEED;
                applyLavaSpeed = lava && lavaWalkOnType == WalkOnType.ABLE_WITH_SPEED;
            } else if (!this.player.field_70170_p.field_72995_K && waterWalkOnType.canWalk() && this.player.func_70090_H()) {
                this.player.func_70050_g(this.player.func_205010_bg());
            }
        }
        if (!this.player.field_70170_p.field_72995_K && (attribute = this.player.func_110148_a(Attributes.field_233821_d_)) != null) {
            this.updateSpeed(attribute, applyWaterSpeed, WATER_SPEED_BOOST);
            this.updateSpeed(attribute, applyLavaSpeed, LAVA_SPEED_BOOST);
        }
    }

    private void updateSpeed(ModifiableAttributeInstance attribute, boolean apply, AttributeModifier speedModifier) {
        if (apply) {
            if (!attribute.func_180374_a(speedModifier)) {
                attribute.func_233767_b_(speedModifier);
            }
        } else if (attribute.func_180374_a(speedModifier)) {
            attribute.func_111124_b(speedModifier);
        }
    }

    private WalkOnType canWalkOnWater() {
        if (PlayerHelper.checkHotbarCurios(this.player, stack -> !stack.func_190926_b() && stack.func_77973_b() == PEItems.EVERTIDE_AMULET.get())) {
            return WalkOnType.ABLE_WITH_SPEED;
        }
        ItemStack helmet = this.player.func_184582_a(EquipmentSlotType.HEAD);
        return !helmet.func_190926_b() && helmet.func_77973_b() == PEItems.GEM_HELMET.get() ? WalkOnType.ABLE : WalkOnType.UNABLE;
    }

    private WalkOnType canWalkOnLava() {
        if (PlayerHelper.checkHotbarCurios(this.player, stack -> !stack.func_190926_b() && stack.func_77973_b() == PEItems.VOLCANITE_AMULET.get())) {
            return WalkOnType.ABLE_WITH_SPEED;
        }
        ItemStack chestplate = this.player.func_184582_a(EquipmentSlotType.CHEST);
        return !chestplate.func_190926_b() && chestplate.func_77973_b() == PEItems.GEM_CHESTPLATE.get() ? WalkOnType.ABLE : WalkOnType.UNABLE;
    }

    public static class Provider
    extends BasicCapabilityResolver<CommonInternalAbilities> {
        public Provider(PlayerEntity player) {
            super(() -> new CommonInternalAbilities(player));
        }

        @Override
        @Nonnull
        public Capability<CommonInternalAbilities> getMatchingCapability() {
            return CAPABILITY;
        }
    }

    private static enum WalkOnType {
        ABLE,
        ABLE_WITH_SPEED,
        UNABLE;


        public boolean canWalk() {
            return this != UNABLE;
        }
    }
}

