/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.google.common.collect.Lists;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IAlchBagItem;
import moze_intel.projecte.api.capabilities.item.IAlchChestItem;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.AlchBagItemCapabilityWrapper;
import moze_intel.projecte.capability.AlchChestItemCapabilityWrapper;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlackHoleBand
extends PEToggleItem
implements IAlchBagItem,
IAlchChestItem,
IPedestalItem {
    public BlackHoleBand(Item.Properties props) {
        super(props);
        this.addItemCapability(AlchBagItemCapabilityWrapper::new);
        this.addItemCapability(AlchChestItemCapabilityWrapper::new);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    private ActionResultType tryPickupFluid(World world, PlayerEntity player, ItemStack stack) {
        Fluid fluid;
        BlockRayTraceResult result = BlackHoleBand.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResultType.PASS;
        }
        BlockPos fluidPos = result.func_216350_a();
        BlockState state = world.func_180495_p(fluidPos);
        if (world.func_175660_a(player, fluidPos) && player.func_175151_a(fluidPos, result.func_216354_b(), stack) && state.func_177230_c() instanceof IBucketPickupHandler && (fluid = ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)world, fluidPos, state)) != Fluids.field_204541_a) {
            player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), fluid.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull PlayerEntity player, @Nonnull Hand hand) {
        if (this.tryPickupFluid(world, player, player.func_184586_b(hand)) != ActionResultType.SUCCESS) {
            this.changeMode(player, player.func_184586_b(hand), hand);
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    public void func_77663_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull Entity entity, int slot, boolean held) {
        if (entity instanceof PlayerEntity && ItemHelper.checkItemNBT(stack, "Active")) {
            PlayerEntity player = (PlayerEntity)entity;
            AxisAlignedBB bBox = player.func_174813_aQ().func_186662_g(7.0);
            List itemList = world.func_217357_a(ItemEntity.class, bBox);
            for (ItemEntity item : itemList) {
                if (ItemHelper.simulateFit((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, item.func_92059_d()) >= item.func_92059_d().func_190916_E()) continue;
                WorldHelper.gravitateEntityTowards((Entity)item, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            }
        }
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        DMPedestalTile tile;
        if (!world.field_72995_K && (tile = WorldHelper.getTileEntity(DMPedestalTile.class, (IBlockReader)world, pos, true)) != null) {
            EnumMap<Direction, IItemHandler> nearbyHandlers = new EnumMap<Direction, IItemHandler>(Direction.class);
            block0: for (ItemEntity item : world.func_217357_a(ItemEntity.class, tile.getEffectBounds())) {
                if (!item.func_70089_S()) continue;
                WorldHelper.gravitateEntityTowards((Entity)item, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                if (!(item.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) < 1.21)) continue;
                for (Direction dir : Direction.values()) {
                    IItemHandler inv = nearbyHandlers.computeIfAbsent(dir, direction -> {
                        TileEntity candidate = WorldHelper.getTileEntity((IBlockReader)world, pos.func_177972_a(dir));
                        if (candidate == null) {
                            return null;
                        }
                        return WorldHelper.getItemHandler(candidate, dir);
                    });
                    ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)item.func_92059_d(), (boolean)false);
                    if (result.func_190926_b()) {
                        item.func_70106_y();
                        continue block0;
                    }
                    item.func_92058_a(result);
                }
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        return Lists.newArrayList((Object[])new ITextComponent[]{PELang.PEDESTAL_BLACK_HOLE_BAND_1.translateColored(TextFormatting.BLUE, new Object[0]), PELang.PEDESTAL_BLACK_HOLE_BAND_2.translateColored(TextFormatting.BLUE, new Object[0])});
    }

    @Override
    public void updateInAlchChest(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
        AlchChestTile tile = WorldHelper.getTileEntity(AlchChestTile.class, (IBlockReader)world, pos, true);
        if (tile != null && ItemHelper.checkItemNBT(stack, "Active")) {
            int tileX = pos.func_177958_n();
            int tileY = pos.func_177956_o();
            int tileZ = pos.func_177952_p();
            AxisAlignedBB aabb = new AxisAlignedBB((double)(tileX - 5), (double)(tileY - 5), (double)(tileZ - 5), (double)(tileX + 5), (double)(tileY + 5), (double)(tileZ + 5));
            double centeredX = (double)tileX + 0.5;
            double centeredY = (double)tileY + 0.5;
            double centeredZ = (double)tileZ + 0.5;
            for (ItemEntity e : world.func_217357_a(ItemEntity.class, aabb)) {
                WorldHelper.gravitateEntityTowards((Entity)e, centeredX, centeredY, centeredZ);
                if (e.func_130014_f_().field_72995_K || !e.func_70089_S() || !(e.func_70092_e(centeredX, centeredY, centeredZ) < 1.21)) continue;
                tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
                    ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)e.func_92059_d(), (boolean)false);
                    if (!result.func_190926_b()) {
                        e.func_92058_a(result);
                    } else {
                        e.func_70106_y();
                    }
                });
            }
        }
    }

    @Override
    public boolean updateInAlchBag(@Nonnull IItemHandler inv, @Nonnull PlayerEntity player, @Nonnull ItemStack stack) {
        if (ItemHelper.checkItemNBT(stack, "Active")) {
            for (ItemEntity e : player.func_130014_f_().func_217357_a(ItemEntity.class, player.func_174813_aQ().func_186662_g(5.0))) {
                WorldHelper.gravitateEntityTowards((Entity)e, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            }
        }
        return false;
    }
}

