/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityHomingArrow;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.to_server.LeftClickArchangelPKT;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class ArchangelSmite
extends PEToggleItem
implements IPedestalItem {
    public ArchangelSmite(Item.Properties props) {
        super(props);
        MinecraftForge.EVENT_BUS.addListener(this::emptyLeftClick);
        MinecraftForge.EVENT_BUS.addListener(this::leftClickBlock);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
    }

    public void fireVolley(ItemStack stack, PlayerEntity player) {
        for (int i = 0; i < 10; ++i) {
            this.fireArrow(stack, player.field_70170_p, (LivingEntity)player, 4.0f);
        }
    }

    private void emptyLeftClick(PlayerInteractEvent.LeftClickEmpty evt) {
        PacketHandler.sendToServer(new LeftClickArchangelPKT());
    }

    private void leftClickBlock(PlayerInteractEvent.LeftClickBlock evt) {
        if (!evt.getWorld().field_72995_K && evt.getUseItem() != Event.Result.DENY && !evt.getItemStack().func_190926_b() && evt.getItemStack().func_77973_b() == this) {
            this.fireVolley(evt.getItemStack(), evt.getPlayer());
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (!player.field_70170_p.field_72995_K) {
            this.fireVolley(stack, player);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int invSlot, boolean isSelected) {
        if (!world.field_72995_K && this.getMode(stack) == 1 && entity instanceof LivingEntity) {
            this.fireArrow(stack, world, (LivingEntity)entity, 1.0f);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull PlayerEntity player, @Nonnull Hand hand) {
        if (!world.field_72995_K) {
            this.fireArrow(player.func_184586_b(hand), world, (LivingEntity)player, 1.0f);
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    private void fireArrow(ItemStack ring, World world, LivingEntity shooter, float inaccuracy) {
        EntityHomingArrow arrow = new EntityHomingArrow(world, shooter, 2.0f);
        if (!(shooter instanceof PlayerEntity) || ArchangelSmite.consumeFuel((PlayerEntity)shooter, ring, EMCHelper.getEmcValue((IItemProvider)Items.field_151032_g), true)) {
            arrow.func_234612_a_((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, 3.0f, inaccuracy);
            world.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
            world.func_217376_c((Entity)arrow);
        }
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        DMPedestalTile tile;
        if (!world.field_72995_K && ProjectEConfig.server.cooldown.pedestal.archangel.get() != -1 && (tile = WorldHelper.getTileEntity(DMPedestalTile.class, (IBlockReader)world, pos, true)) != null) {
            if (tile.getActivityCooldown() == 0) {
                if (!world.func_217357_a(MobEntity.class, tile.getEffectBounds()).isEmpty()) {
                    for (int i = 0; i < 3; ++i) {
                        EntityHomingArrow arrow = new EntityHomingArrow(world, (LivingEntity)FakePlayerFactory.get((ServerWorld)((ServerWorld)world), (GameProfile)PECore.FAKEPLAYER_GAMEPROFILE), 2.0f);
                        arrow.func_226288_n_(tile.centeredX, tile.centeredY + 2.0, tile.centeredZ);
                        arrow.func_213293_j(0.0, 1.0, 0.0);
                        arrow.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 0.5f);
                        world.func_217376_c((Entity)arrow);
                    }
                }
                tile.setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.archangel.get());
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (ProjectEConfig.server.cooldown.pedestal.archangel.get() != -1) {
            list.add((ITextComponent)PELang.PEDESTAL_ARCHANGEL_1.translateColored(TextFormatting.BLUE, new Object[0]));
            list.add((ITextComponent)PELang.PEDESTAL_ARCHANGEL_2.translateColored(TextFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.archangel.get())));
        }
        return list;
    }
}

