/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.armor;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class GemHelmet
extends GemArmorBase {
    public GemHelmet(Item.Properties props) {
        super(EquipmentSlotType.HEAD, props);
    }

    public static void toggleNightVision(ItemStack helm, PlayerEntity player) {
        boolean value;
        CompoundNBT helmetTag = helm.func_196082_o();
        if (helmetTag.func_150297_b("NightVision", 1)) {
            value = !helmetTag.func_74767_n("NightVision");
            helmetTag.func_74757_a("NightVision", value);
        } else {
            helmetTag.func_74757_a("NightVision", true);
            value = true;
        }
        if (value) {
            player.func_145747_a((ITextComponent)PELang.NIGHT_VISION.translate(TextFormatting.GREEN, PELang.GEM_ENABLED), Util.field_240973_b_);
        } else {
            player.func_145747_a((ITextComponent)PELang.NIGHT_VISION.translate(TextFormatting.RED, PELang.GEM_DISABLED), Util.field_240973_b_);
        }
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltips, @Nonnull ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltips, flags);
        tooltips.add((ITextComponent)PELang.GEM_LORE_HELM.translate(new Object[0]));
        tooltips.add((ITextComponent)PELang.NIGHT_VISION_PROMPT.translate(ClientKeyHelper.getKeyName(PEKeybind.HELMET_TOGGLE)));
        if (ItemHelper.checkItemNBT(stack, "NightVision")) {
            tooltips.add((ITextComponent)PELang.NIGHT_VISION.translate(TextFormatting.GREEN, PELang.GEM_ENABLED));
        } else {
            tooltips.add((ITextComponent)PELang.NIGHT_VISION.translate(TextFormatting.RED, PELang.GEM_DISABLED));
        }
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!world.field_72995_K) {
            player.getCapability(InternalTimers.CAPABILITY).ifPresent(handler -> {
                handler.activateHeal();
                if (player.func_110143_aJ() < player.func_110138_aP() && handler.canHeal()) {
                    player.func_70691_i(2.0f);
                }
            });
            if (ItemHelper.checkItemNBT(stack, "NightVision")) {
                player.func_195064_c(new EffectInstance(Effects.field_76439_r, 220, 0, true, false));
            } else {
                player.func_195063_d(Effects.field_76439_r);
            }
        }
    }

    public void doZap(PlayerEntity player) {
        BlockRayTraceResult strikeResult;
        if (ProjectEConfig.server.difficulty.offensiveAbilities.get() && (strikeResult = PlayerHelper.getBlockLookingAt(player, 120.0)).func_216346_c() != RayTraceResult.Type.MISS) {
            BlockPos strikePos = strikeResult.func_216350_a();
            World world = player.func_130014_f_();
            LightningBoltEntity lightning = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
            if (lightning != null) {
                lightning.func_233576_c_(Vector3d.func_237489_a_((Vector3i)strikePos));
                lightning.func_204809_d((ServerPlayerEntity)player);
                world.func_217376_c((Entity)lightning);
            }
        }
    }
}

