/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.IStepAssister;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.DistExecutor;

public class GemFeet
extends GemArmorBase
implements IFlightProvider,
IStepAssister {
    private static final UUID MODIFIER = UUID.fromString("A4334312-DFF8-4582-9F4F-62AD0C070475");
    private final Multimap<Attribute, AttributeModifier> attributes;

    public GemFeet(Item.Properties props) {
        super(EquipmentSlotType.FEET, props);
        ImmutableMultimap.Builder attributesBuilder = ImmutableMultimap.builder();
        attributesBuilder.putAll(this.func_111205_h(EquipmentSlotType.FEET));
        attributesBuilder.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(MODIFIER, "Armor modifier", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        this.attributes = attributesBuilder.build();
    }

    public void toggleStepAssist(ItemStack boots, PlayerEntity player) {
        boolean value;
        CompoundNBT bootsTag = boots.func_196082_o();
        if (bootsTag.func_150297_b("StepAssist", 1)) {
            value = !bootsTag.func_74767_n("StepAssist");
            bootsTag.func_74757_a("StepAssist", value);
        } else {
            bootsTag.func_74757_a("StepAssist", true);
            value = true;
        }
        if (value) {
            player.func_145747_a((ITextComponent)PELang.STEP_ASSIST.translate(TextFormatting.GREEN, PELang.GEM_ENABLED), Util.field_240973_b_);
        } else {
            player.func_145747_a((ITextComponent)PELang.STEP_ASSIST.translate(TextFormatting.RED, PELang.GEM_DISABLED), Util.field_240973_b_);
        }
    }

    private static boolean isJumpPressed() {
        return (Boolean)DistExecutor.unsafeRunForDist(() -> () -> Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d(), () -> () -> false);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!world.field_72995_K) {
            ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
            playerMP.field_70143_R = 0.0f;
        } else {
            if (!player.field_71075_bZ.field_75100_b && GemFeet.isJumpPressed()) {
                player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, 0.1, 0.0));
            }
            if (!player.func_233570_aj_()) {
                if (player.func_213322_ci().func_82617_b() <= 0.0) {
                    player.func_213317_d(player.func_213322_ci().func_216372_d(1.0, 0.9, 1.0));
                }
                if (!player.field_71075_bZ.field_75100_b) {
                    if (player.field_191988_bg < 0.0f) {
                        player.func_213317_d(player.func_213322_ci().func_216372_d(0.9, 1.0, 0.9));
                    } else if (player.field_191988_bg > 0.0f && player.func_213322_ci().func_189985_c() < 3.0) {
                        player.func_213317_d(player.func_213322_ci().func_216372_d(1.1, 1.0, 1.1));
                    }
                }
            }
        }
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltips, @Nonnull ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltips, flags);
        tooltips.add((ITextComponent)PELang.GEM_LORE_FEET.translate(new Object[0]));
        tooltips.add((ITextComponent)PELang.STEP_ASSIST_PROMPT.translate(ClientKeyHelper.getKeyName(PEKeybind.BOOTS_TOGGLE)));
        if (ItemHelper.checkItemNBT(stack, "StepAssist")) {
            tooltips.add((ITextComponent)PELang.STEP_ASSIST.translate(TextFormatting.GREEN, PELang.GEM_ENABLED));
        } else {
            tooltips.add((ITextComponent)PELang.STEP_ASSIST.translate(TextFormatting.RED, PELang.GEM_DISABLED));
        }
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType slot, ItemStack stack) {
        return slot == EquipmentSlotType.FEET ? this.attributes : super.getAttributeModifiers(slot, stack);
    }

    @Override
    public boolean canProvideFlight(ItemStack stack, ServerPlayerEntity player) {
        return player.func_184582_a(EquipmentSlotType.FEET) == stack;
    }

    @Override
    public boolean canAssistStep(ItemStack stack, ServerPlayerEntity player) {
        return player.func_184582_a(EquipmentSlotType.FEET) == stack && ItemHelper.checkItemNBT(stack, "StepAssist");
    }
}

