/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.item.IAlchBagItem;
import moze_intel.projecte.api.capabilities.item.IAlchChestItem;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.AlchBagItemCapabilityWrapper;
import moze_intel.projecte.capability.AlchChestItemCapabilityWrapper;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class RepairTalisman
extends ItemPE
implements IAlchBagItem,
IAlchChestItem,
IPedestalItem {
    private static final Predicate<ItemStack> CAN_REPAIR_ITEM = stack -> !stack.func_190926_b() && !stack.getCapability(ProjectEAPI.MODE_CHANGER_ITEM_CAPABILITY).isPresent() && ItemHelper.isRepairableDamagedItem(stack);

    public RepairTalisman(Item.Properties props) {
        super(props);
        this.addItemCapability(AlchBagItemCapabilityWrapper::new);
        this.addItemCapability(AlchChestItemCapabilityWrapper::new);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int invSlot, boolean isSelected) {
        if (!world.field_72995_K && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.getCapability(InternalTimers.CAPABILITY).ifPresent(timers -> {
                timers.activateRepair();
                if (timers.canRepair()) {
                    RepairTalisman.repairAllItems(player);
                }
            });
        }
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        DMPedestalTile tile;
        if (!world.field_72995_K && ProjectEConfig.server.cooldown.pedestal.repair.get() != -1 && (tile = WorldHelper.getTileEntity(DMPedestalTile.class, (IBlockReader)world, pos, true)) != null) {
            if (tile.getActivityCooldown() == 0) {
                world.func_217357_a(ServerPlayerEntity.class, tile.getEffectBounds()).forEach(RepairTalisman::repairAllItems);
                tile.setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.repair.get());
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (ProjectEConfig.server.cooldown.pedestal.repair.get() != -1) {
            list.add((ITextComponent)PELang.PEDESTAL_REPAIR_TALISMAN_1.translateColored(TextFormatting.BLUE, new Object[0]));
            list.add((ITextComponent)PELang.PEDESTAL_REPAIR_TALISMAN_2.translateColored(TextFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.repair.get())));
        }
        return list;
    }

    @Override
    public void updateInAlchChest(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
        AlchChestTile tile;
        if (!world.field_72995_K && (tile = WorldHelper.getTileEntity(AlchChestTile.class, (IBlockReader)world, pos, true)) != null) {
            CompoundNBT nbt = stack.func_196082_o();
            byte coolDown = nbt.func_74771_c("Cooldown");
            if (coolDown > 0) {
                nbt.func_74774_a("Cooldown", (byte)(coolDown - 1));
            } else {
                tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
                    if (RepairTalisman.repairAllItems(inv, CAN_REPAIR_ITEM)) {
                        nbt.func_74774_a("Cooldown", (byte)19);
                        tile.markDirty(false, false);
                    }
                });
            }
        }
    }

    @Override
    public boolean updateInAlchBag(@Nonnull IItemHandler inv, @Nonnull PlayerEntity player, @Nonnull ItemStack stack) {
        if (player.func_130014_f_().field_72995_K) {
            return false;
        }
        CompoundNBT nbt = stack.func_196082_o();
        byte coolDown = nbt.func_74771_c("Cooldown");
        if (coolDown > 0) {
            nbt.func_74774_a("Cooldown", (byte)(coolDown - 1));
        } else if (RepairTalisman.repairAllItems(inv, CAN_REPAIR_ITEM)) {
            nbt.func_74774_a("Cooldown", (byte)19);
            return true;
        }
        return false;
    }

    private static void repairAllItems(PlayerEntity player) {
        Predicate<ItemStack> canRepairPlayerItem = CAN_REPAIR_ITEM.and(stack -> stack != player.func_184614_ca() || !player.field_82175_bq);
        player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> RepairTalisman.repairAllItems(inv, canRepairPlayerItem));
        IItemHandler curios = PlayerHelper.getCurios(player);
        if (curios != null) {
            RepairTalisman.repairAllItems(curios, canRepairPlayerItem);
        }
    }

    private static boolean repairAllItems(IItemHandler inv, Predicate<ItemStack> canRepairStack) {
        boolean hasAction = false;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack invStack = inv.getStackInSlot(i);
            if (!canRepairStack.test(invStack)) continue;
            invStack.func_196085_b(invStack.func_77952_i() - 1);
            if (hasAction) continue;
            hasAction = true;
        }
        return hasAction;
    }
}

