/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.blocks.Relay;
import moze_intel.projecte.gameObjs.container.PEContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import moze_intel.projecte.gameObjs.registration.impl.BlockRegistryObject;
import moze_intel.projecte.gameObjs.registration.impl.ContainerTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.gameObjs.tiles.RelayMK1Tile;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.IntReferenceHolder;
import net.minecraftforge.items.IItemHandler;

public class RelayMK1Container
extends PEContainer {
    public final RelayMK1Tile tile;
    private final IntReferenceHolder kleinChargeProgress = IntReferenceHolder.func_221492_a();
    private final IntReferenceHolder inputBurnProgress = IntReferenceHolder.func_221492_a();
    public final PEContainer.BoxedLong emc = new PEContainer.BoxedLong();

    public RelayMK1Container(int windowId, PlayerInventory invPlayer, RelayMK1Tile relay) {
        this(PEContainerTypes.RELAY_MK1_CONTAINER, windowId, invPlayer, relay);
    }

    protected RelayMK1Container(ContainerTypeRegistryObject<? extends RelayMK1Container> type, int windowId, PlayerInventory invPlayer, RelayMK1Tile relay) {
        super(type, windowId);
        this.longFields.add(this.emc);
        this.func_216958_a(this.kleinChargeProgress);
        this.func_216958_a(this.inputBurnProgress);
        this.tile = relay;
        this.initSlots(invPlayer);
    }

    void initSlots(PlayerInventory invPlayer) {
        IItemHandler input = this.tile.getInput();
        IItemHandler output = this.tile.getOutput();
        this.func_75146_a((Slot)new ValidatedSlot(output, 0, 127, 43, SlotPredicates.EMC_HOLDER));
        this.func_75146_a((Slot)new ValidatedSlot(input, 0, 67, 43, SlotPredicates.RELAY_INV));
        int counter = 1;
        for (int i = 1; i >= 0; --i) {
            for (int j = 2; j >= 0; --j) {
                this.func_75146_a((Slot)new ValidatedSlot(input, counter++, 27 + i * 18, 17 + j * 18, SlotPredicates.RELAY_INV));
            }
        }
        this.addPlayerInventory(invPlayer, 8, 95);
    }

    @Override
    public void func_75142_b() {
        this.emc.set(this.tile.getStoredEmc());
        this.kleinChargeProgress.func_221494_a((int)(this.tile.getItemChargeProportion() * 8000.0));
        this.inputBurnProgress.func_221494_a((int)(this.tile.getInputBurnProportion() * 8000.0));
        super.func_75142_b();
    }

    protected BlockRegistryObject<Relay, ?> getValidBlock() {
        return PEBlocks.RELAY;
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return RelayMK1Container.stillValid(player, this.tile, this.getValidBlock());
    }

    public double getKleinChargeProgress() {
        return (double)this.kleinChargeProgress.func_221495_b() / 8000.0;
    }

    public double getInputBurnProgress() {
        return (double)this.inputBurnProgress.func_221495_b() / 8000.0;
    }
}

