/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.AbstractNBTNSSTag;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.utils.ItemInfoHelper;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

@EMCMapper
public class BrewingMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    private static final Set<ItemInfo> allReagents = new HashSet<ItemInfo>();
    private static final Set<ItemInfo> allInputs = new HashSet<ItemInfo>();
    private static int totalConversions;
    private static int totalPotionItems;
    private static List<Object> itemConversions;
    private static List<Object> typeConversions;
    private static Class<?> mixPredicateClass;

    private static boolean mapAllReagents() {
        int conversionCount;
        if (itemConversions == null || typeConversions == null) {
            try {
                typeConversions = (List)ObfuscationReflectionHelper.getPrivateValue(PotionBrewing.class, null, (String)"field_185213_a");
                if (typeConversions == null) {
                    PECore.LOGGER.error("Error getting type conversion field.");
                    return false;
                }
                itemConversions = (List)ObfuscationReflectionHelper.getPrivateValue(PotionBrewing.class, null, (String)"field_185214_b");
            }
            catch (ObfuscationReflectionHelper.UnableToAccessFieldException | ObfuscationReflectionHelper.UnableToFindFieldException e) {
                PECore.LOGGER.error("Error getting conversion field: ", e);
                return false;
            }
            if (itemConversions == null) {
                PECore.LOGGER.error("Error getting item conversion field.");
                return false;
            }
        }
        if (totalConversions == (conversionCount = itemConversions.size() + typeConversions.size())) {
            return true;
        }
        allReagents.clear();
        if (mixPredicateClass == null) {
            try {
                mixPredicateClass = Class.forName("net.minecraft.potion.PotionBrewing$MixPredicate");
            }
            catch (ClassNotFoundException e) {
                PECore.LOGGER.error("Brewing mapper: could not find MixPredicate");
                return false;
            }
        }
        if (BrewingMapper.addReagents(itemConversions) || BrewingMapper.addReagents(typeConversions)) {
            return false;
        }
        totalConversions = conversionCount;
        return true;
    }

    private static boolean addReagents(List<Object> conversions) {
        for (Object conversion : conversions) {
            try {
                Ingredient reagent = (Ingredient)ObfuscationReflectionHelper.getPrivateValue(mixPredicateClass, (Object)conversion, (String)"field_185199_b");
                if (reagent == null) {
                    PECore.LOGGER.error("Brewing mapper: could not find reagents field.");
                    return true;
                }
                for (ItemStack r : reagent.func_193365_a()) {
                    allReagents.add(ItemInfo.fromStack(r));
                }
            }
            catch (Exception ex) {
                PECore.LOGGER.error("Brewing mapper: could not find field: {}", (Object)ex.getMessage());
                return true;
            }
        }
        return false;
    }

    private static void mapAllInputs() {
        int count = PotionBrewing.field_185215_c.size();
        if (totalPotionItems == count) {
            return;
        }
        allInputs.clear();
        HashSet<ItemInfo> inputs = new HashSet<ItemInfo>();
        for (Ingredient potionItem : PotionBrewing.field_185215_c) {
            ItemStack[] matchingStacks = BrewingMapper.getMatchingStacks(potionItem);
            if (matchingStacks == null) continue;
            for (ItemStack input : matchingStacks) {
                inputs.add(ItemInfo.fromStack(input));
            }
        }
        for (Potion potion : ForgeRegistries.POTION_TYPES.getValues()) {
            for (ItemInfo input : inputs) {
                allInputs.add(ItemInfoHelper.makeWithPotion(input, potion));
            }
        }
        totalPotionItems = count;
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, CommentedFileConfig config, DataPackRegistries dataPackRegistries, IResourceManager resourceManager) {
        boolean vanillaRetrieved = BrewingMapper.mapAllReagents();
        if (vanillaRetrieved) {
            BrewingMapper.mapAllInputs();
        }
        HashMap<AbstractNBTNSSTag, Integer> waterIngredients = new HashMap<AbstractNBTNSSTag, Integer>();
        waterIngredients.put(NSSItem.createItem((IItemProvider)Items.field_151069_bo), 1);
        waterIngredients.put(NSSFluid.createTag((ITag<Fluid>)FluidTags.field_206959_a), 333);
        mapper.addConversion(1, (NormalizedSimpleStack)NSSItem.createItem(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b)), waterIngredients);
        HashSet canNotMap = new HashSet();
        int recipeCount = 0;
        List recipes = BrewingRecipeRegistry.getRecipes();
        for (IBrewingRecipe iBrewingRecipe : recipes) {
            if (iBrewingRecipe instanceof BrewingRecipe) {
                BrewingRecipe brewingRecipe = (BrewingRecipe)iBrewingRecipe;
                Ingredient input = brewingRecipe.getInput();
                Ingredient reagent = brewingRecipe.getIngredient();
                ItemStack output = brewingRecipe.getOutput();
                ItemStack[] validInputs = BrewingMapper.getMatchingStacks(input);
                ItemStack[] validReagents = BrewingMapper.getMatchingStacks(reagent);
                if (validInputs == null || validReagents == null) continue;
                NSSItem nssOut = NSSItem.createItem(output);
                for (ItemStack validInput : validInputs) {
                    NSSItem nssInput = NSSItem.createItem(validInput);
                    for (ItemStack validReagent : validReagents) {
                        HashMap<NSSItem, Integer> ingredientsWithAmount = new HashMap<NSSItem, Integer>();
                        ingredientsWithAmount.put(nssInput, 3);
                        ingredientsWithAmount.put(NSSItem.createItem(validReagent), validReagent.func_190916_E());
                        mapper.addConversion(3 * output.func_190916_E(), (NormalizedSimpleStack)nssOut, ingredientsWithAmount);
                        ++recipeCount;
                    }
                }
                continue;
            }
            if (iBrewingRecipe instanceof VanillaBrewingRecipe) {
                if (!vanillaRetrieved) {
                    canNotMap.add(iBrewingRecipe.getClass());
                    continue;
                }
                for (ItemInfo inputInfo : allInputs) {
                    ItemStack validInput = inputInfo.createStack();
                    NSSItem nssInput = NSSItem.createItem(validInput);
                    for (ItemInfo reagentInfo : allReagents) {
                        ItemStack validReagent = reagentInfo.createStack();
                        ItemStack output = iBrewingRecipe.getOutput(validInput, validReagent);
                        if (output.func_190926_b()) continue;
                        HashMap<NSSItem, Integer> ingredientsWithAmount = new HashMap<NSSItem, Integer>();
                        ingredientsWithAmount.put(nssInput, 3);
                        ingredientsWithAmount.put(NSSItem.createItem(validReagent), 1);
                        mapper.addConversion(3 * output.func_190916_E(), (NormalizedSimpleStack)NSSItem.createItem(output), ingredientsWithAmount);
                        ++recipeCount;
                    }
                }
                continue;
            }
            canNotMap.add(iBrewingRecipe.getClass());
        }
        PECore.debugLog("BrewingMapper Statistics:", new Object[0]);
        PECore.debugLog("Found {} Brewing Recipes", recipeCount);
        for (Class clazz : canNotMap) {
            PECore.debugLog("Could not map Brewing Recipes with Type: {}", clazz.getName());
        }
    }

    @Override
    public String getName() {
        return "BrewingMapper";
    }

    @Override
    public String getDescription() {
        return "Add Conversions for Brewing Recipes";
    }

    @Nullable
    private static ItemStack[] getMatchingStacks(Ingredient ingredient) {
        try {
            return ingredient.func_193365_a();
        }
        catch (Exception e) {
            return null;
        }
    }
}

