/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.arithmetic.IValueArithmetic;
import moze_intel.projecte.api.mapper.generator.IValueGenerator;
import moze_intel.projecte.emc.collector.MappingCollector;

public class SimpleGraphMapper<T, V extends Comparable<V>, A extends IValueArithmetic<V>>
extends MappingCollector<T, V, A>
implements IValueGenerator<T, V> {
    private static final boolean OVERWRITE_FIXED_VALUES = false;
    private final V ZERO;
    private static boolean logFoundExploits = true;

    public SimpleGraphMapper(A arithmetic) {
        super(arithmetic);
        this.ZERO = arithmetic.getZero();
    }

    private static <K, V extends Comparable<V>> boolean hasSmallerOrEqual(Map<K, V> m, K key, V value) {
        return m.containsKey(key) && ((Comparable)m.get(key)).compareTo(value) <= 0;
    }

    private static <K, V extends Comparable<V>> boolean hasSmaller(Map<K, V> m, K key, V value) {
        return m.containsKey(key) && ((Comparable)m.get(key)).compareTo(value) < 0;
    }

    static void setLogFoundExploits(boolean log) {
        logFoundExploits = log;
    }

    private static <K, V extends Comparable<V>> boolean updateMapWithMinimum(Map<K, V> m, K key, V value) {
        if (!SimpleGraphMapper.hasSmaller(m, key, value)) {
            m.put(key, value);
            return true;
        }
        return false;
    }

    private boolean canOverride(T something, V value) {
        if (this.fixValueBeforeInherit.containsKey(something)) {
            return ((Comparable)this.fixValueBeforeInherit.get(something)).compareTo(value) == 0;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<T, V> generateValues() {
        HashMap values = new HashMap();
        HashMap<Object, V> changedValues = new HashMap<Object, V>();
        HashMap<Object, String> reasonForChange = new HashMap<Object, String>();
        for (Map.Entry entry : this.fixValueBeforeInherit.entrySet()) {
            changedValues.put(entry.getKey(), entry.getValue());
            reasonForChange.put(entry.getKey(), "fixValueBefore");
        }
        while (!changedValues.isEmpty()) {
            while (!changedValues.isEmpty()) {
                HashMap nextChangedValues = new HashMap();
                SimpleGraphMapper.debugPrintln("Loop");
                for (Map.Entry entry : changedValues.entrySet()) {
                    if (!this.canOverride(entry.getKey(), (Comparable)entry.getValue()) || !SimpleGraphMapper.updateMapWithMinimum(values, entry.getKey(), (Comparable)entry.getValue())) continue;
                    SimpleGraphMapper.debugFormat("Set Value for {} to {} because {}", entry.getKey(), entry.getValue(), reasonForChange.get(entry.getKey()));
                    for (MappingCollector.Conversion conversion : this.getUsesFor(entry.getKey())) {
                        Object conversionValue;
                        if (this.overwriteConversion.containsKey(conversion.output) && this.overwriteConversion.get(conversion.output) != conversion || (conversionValue = conversion.arithmeticForConversion.div(this.valueForConversion(values, conversion), conversion.outnumber)).compareTo(this.ZERO) <= 0 && !conversion.arithmeticForConversion.isFree(conversionValue) || SimpleGraphMapper.hasSmallerOrEqual(values, conversion.output, conversionValue) || !SimpleGraphMapper.updateMapWithMinimum(nextChangedValues, conversion.output, conversionValue)) continue;
                        reasonForChange.put(conversion.output, (String)entry.getKey());
                    }
                }
                changedValues = nextChangedValues;
            }
            for (Map.Entry entry : this.conversionsFor.entrySet()) {
                void var6_9;
                Object var6_8 = null;
                for (MappingCollector.Conversion conversion : (Set)entry.getValue()) {
                    Object ingredientValue = this.valueForConversion(values, conversion);
                    Object resultValueConversion = conversion.arithmeticForConversion.div(ingredientValue, conversion.outnumber);
                    Comparable resultValueActual = (Comparable)values.getOrDefault(entry.getKey(), this.ZERO);
                    if (!(resultValueConversion.compareTo(this.ZERO) <= 0 && !conversion.arithmeticForConversion.isFree(resultValueConversion) || var6_9 != null && var6_9.compareTo(resultValueConversion) <= 0)) {
                        Object v = resultValueConversion;
                    }
                    if (this.ZERO.compareTo(ingredientValue) >= 0 || resultValueConversion.compareTo((Comparable)resultValueActual) >= 0) continue;
                    if (this.overwriteConversion.containsKey(conversion.output) && this.overwriteConversion.get(conversion.output) != conversion) {
                        if (!logFoundExploits) continue;
                        PECore.LOGGER.warn("EMC Exploit: \"{}\" ingredient cost: {} value of result: {} setValueFromConversion: {}", (Object)conversion, ingredientValue, (Object)resultValueActual, this.overwriteConversion.get(conversion.output));
                        continue;
                    }
                    if (this.canOverride(entry.getKey(), this.ZERO)) {
                        SimpleGraphMapper.debugFormat("Setting {} to 0 because result ({}) > cost ({}): {}", entry.getKey(), resultValueActual, ingredientValue, conversion);
                        changedValues.put(conversion.output, this.ZERO);
                        reasonForChange.put(conversion.output, "exploit recipe");
                        continue;
                    }
                    if (!logFoundExploits) continue;
                    PECore.LOGGER.warn("EMC Exploit: ingredients ({}) cost {} but output value is {}", (Object)conversion, ingredientValue, (Object)resultValueActual);
                }
                if (var6_9 != null && !var6_9.equals(this.ZERO) || !values.containsKey(entry.getKey()) || ((Comparable)values.get(entry.getKey())).equals(this.ZERO) || !this.canOverride(entry.getKey(), this.ZERO) || SimpleGraphMapper.hasSmaller(values, entry.getKey(), this.ZERO)) continue;
                SimpleGraphMapper.debugFormat("Removing Value for {} because it does not have any nonzero-conversions anymore.", entry.getKey());
                changedValues.put(entry.getKey(), this.ZERO);
                reasonForChange.put(entry.getKey(), "all conversions dead");
            }
        }
        SimpleGraphMapper.debugPrintln("");
        for (Map.Entry fixedValueAfterInherit : this.fixValueAfterInherit.entrySet()) {
            values.put(fixedValueAfterInherit.getKey(), fixedValueAfterInherit.getValue());
        }
        values.entrySet().removeIf(something -> this.arithmetic.isFree((Comparable)something.getValue()));
        return values;
    }

    private V valueForConversion(Map<T, V> values, MappingCollector.Conversion conversion) {
        try {
            return this.valueForConversionUnsafe(values, conversion);
        }
        catch (ArithmeticException e) {
            PECore.LOGGER.warn("Could not calculate value for {}: {}", (Object)conversion.toString(), (Object)e.toString());
            return this.ZERO;
        }
        catch (Exception e) {
            PECore.LOGGER.warn("Could not calculate value for {}: {}", (Object)conversion.toString(), (Object)e.toString(), (Object)e);
            return this.ZERO;
        }
    }

    private V valueForConversionUnsafe(Map<T, V> values, MappingCollector.Conversion conversion) {
        Object value = conversion.value;
        boolean allIngredientsAreFree = true;
        boolean hasPositiveIngredientValues = false;
        for (Map.Entry entry : conversion.ingredientsWithAmount.entrySet()) {
            if (values.containsKey(entry.getKey())) {
                Comparable ingredientValue = conversion.arithmeticForConversion.mul(entry.getValue().intValue(), (Comparable)((Comparable)values.get(entry.getKey())));
                if (ingredientValue.compareTo(this.ZERO) != 0) {
                    if (conversion.arithmeticForConversion.isFree((Comparable)ingredientValue)) continue;
                    value = conversion.arithmeticForConversion.add(value, (Comparable)ingredientValue);
                    if (ingredientValue.compareTo(this.ZERO) > 0 && entry.getValue() > 0) {
                        hasPositiveIngredientValues = true;
                    }
                    allIngredientsAreFree = false;
                    continue;
                }
                return this.ZERO;
            }
            return this.ZERO;
        }
        if (allIngredientsAreFree || hasPositiveIngredientValues && value.compareTo(this.ZERO) <= 0) {
            return (V)conversion.arithmeticForConversion.getFree();
        }
        return value;
    }
}

