/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.util.MCUtil;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.compat.jei.IPRecipeCategory;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class CokerUnitRecipeCategory
extends IPRecipeCategory<CokerUnitRecipe> {
    public static final ResourceLocation ID = ResourceUtils.ip("cokerunit");
    private final IDrawableStatic tankOverlay;

    public CokerUnitRecipeCategory(IGuiHelper guiHelper) {
        super(CokerUnitRecipe.class, guiHelper, ID, "block.immersivepetroleum.cokerunit");
        ResourceLocation background = ResourceUtils.ip("textures/gui/jei/coker.png");
        ResourceLocation coker = ResourceUtils.ip("textures/gui/coker.png");
        this.setBackground(guiHelper.createDrawable(background, 0, 0, 150, 77));
        this.setIcon(new ItemStack((IItemProvider)IPContent.Multiblock.cokerunit));
        this.tankOverlay = guiHelper.createDrawable(coker, 200, 0, 20, 51);
    }

    public void setIngredients(CokerUnitRecipe recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.FLUID, recipe.inputFluid.getMatchingFluidStacks());
        ingredients.setInputs(VanillaTypes.ITEM, Arrays.asList(recipe.inputItem.getMatchingStacks()));
        ingredients.setOutputs(VanillaTypes.FLUID, recipe.outputFluid.getMatchingFluidStacks());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.outputItem);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CokerUnitRecipe recipe, IIngredients ingredients) {
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int total = 0;
        List list = recipe.inputFluid.getMatchingFluidStacks();
        if (!list.isEmpty()) {
            for (FluidStack f : list) {
                total += f.getAmount();
            }
        } else {
            total = 100;
        }
        guiFluidStacks.init(0, true, 2, 2, 20, 51, total, false, (IDrawable)this.tankOverlay);
        guiFluidStacks.set(0, list);
        total = 0;
        list = recipe.outputFluid.getMatchingFluidStacks();
        if (!list.isEmpty()) {
            for (FluidStack f : list) {
                total += f.getAmount();
            }
        } else {
            total = 100;
        }
        guiFluidStacks.init(1, false, 50, 2, 20, 51, total, false, (IDrawable)this.tankOverlay);
        guiFluidStacks.set(1, list);
        guiItemStacks.init(0, true, 3, 57);
        guiItemStacks.set(0, Arrays.asList(recipe.inputItem.getMatchingStacks()));
        guiItemStacks.init(1, true, 51, 57);
        guiItemStacks.set(1, Arrays.asList(recipe.outputItem));
    }

    public void draw(CokerUnitRecipe recipe, MatrixStack matrix, double mouseX, double mouseY) {
        super.draw((Object)recipe, matrix, mouseX, mouseY);
        IDrawable background = this.getBackground();
        int bWidth = background.getWidth();
        int bHeight = background.getHeight();
        FontRenderer font = MCUtil.getFont();
        int time = (recipe.getTotalProcessTime() + 2 + 5) * recipe.inputItem.getCount();
        int energy = recipe.getTotalProcessEnergy();
        String text0 = I18n.func_135052_a((String)"desc.immersiveengineering.info.ift", (Object[])new Object[]{new DecimalFormat("#.##").format(energy)});
        float f = bWidth - 5 - font.func_78256_a(text0);
        int n = bHeight / 3;
        font.getClass();
        font.func_238421_b_(matrix, text0, f, (float)(n + 9), -1);
        String text1 = I18n.func_135052_a((String)"desc.immersiveengineering.info.seconds", (Object[])new Object[]{new DecimalFormat("#.##").format((double)time / 20.0)});
        float f2 = bWidth - 10 - font.func_78256_a(text1);
        int n2 = bHeight / 3;
        font.getClass();
        font.func_238421_b_(matrix, text1, f2, (float)(n2 + 9 * 2), -1);
    }
}

