/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.crafting;

import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import flaxbeard.immersivepetroleum.api.crafting.DistillationRecipe;
import flaxbeard.immersivepetroleum.api.crafting.SulfurRecoveryRecipe;
import flaxbeard.immersivepetroleum.api.crafting.pumpjack.PumpjackHandler;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RecipeReloadListener
implements IResourceManagerReloadListener {
    private final DataPackRegistries dataPackRegistries;

    public RecipeReloadListener(DataPackRegistries dataPackRegistries) {
        this.dataPackRegistries = dataPackRegistries;
    }

    public void func_195410_a(IResourceManager resourceManager) {
        if (this.dataPackRegistries != null) {
            RecipeReloadListener.lists(this.dataPackRegistries.func_240967_e_());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void recipesUpdated(RecipesUpdatedEvent event) {
        if (!Minecraft.func_71410_x().func_71356_B()) {
            RecipeReloadListener.lists(event.getRecipeManager());
        }
    }

    static void lists(RecipeManager recipeManager) {
        Collection recipes = recipeManager.func_199510_b();
        if (recipes.size() == 0) {
            return;
        }
        ImmersivePetroleum.log.info("Loading Distillation Recipes.");
        DistillationRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, DistillationRecipe.class, DistillationRecipe.TYPE);
        ImmersivePetroleum.log.info("Loading Reservoirs.");
        PumpjackHandler.reservoirs = RecipeReloadListener.filterRecipes(recipes, PumpjackHandler.ReservoirType.class, PumpjackHandler.ReservoirType.TYPE);
        ImmersivePetroleum.log.info("Loading Coker-Unit Recipes.");
        CokerUnitRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, CokerUnitRecipe.class, CokerUnitRecipe.TYPE);
        ImmersivePetroleum.log.info("Loading Sulfur Recovery Recipes.");
        SulfurRecoveryRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, SulfurRecoveryRecipe.class, SulfurRecoveryRecipe.TYPE);
    }

    static <R extends IRecipe<?>> Map<ResourceLocation, R> filterRecipes(Collection<IRecipe<?>> recipes, Class<R> recipeClass, IRecipeType<R> recipeType) {
        return recipes.stream().filter(iRecipe -> iRecipe.func_222127_g() == recipeType).map(recipeClass::cast).collect(Collectors.toMap(recipe -> recipe.func_199560_c(), recipe -> recipe));
    }
}

