/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.SampleDrillTileEntity;
import blusunrize.immersiveengineering.common.items.CoresampleItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.api.crafting.pumpjack.PumpjackHandler;
import flaxbeard.immersivepetroleum.api.crafting.pumpjack.ReservoirWorldInfo;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPSaveData;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.fluids.NapalmFluid;
import flaxbeard.immersivepetroleum.common.util.IPEffects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonEventHandler {
    static final Random random = new Random();
    public static Map<ResourceLocation, List<BlockPos>> napalmPositions = new HashMap<ResourceLocation, List<BlockPos>>();
    public static Map<ResourceLocation, List<BlockPos>> toRemove = new HashMap<ResourceLocation, List<BlockPos>>();

    @SubscribeEvent
    public void onSave(WorldEvent.Save event) {
        if (!event.getWorld().func_201670_d()) {
            IPSaveData.markInstanceAsDirty();
        }
    }

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload event) {
        if (!event.getWorld().func_201670_d()) {
            IPSaveData.markInstanceAsDirty();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handlePickupItem(PlayerInteractEvent.RightClickBlock event) {
        TileEntity te;
        BlockPos pos = event.getPos();
        BlockState state = event.getWorld().func_180495_p(pos);
        if (state.func_177230_c() == IEBlocks.MetalDevices.sampleDrill && (te = event.getWorld().func_175625_s(pos)) instanceof SampleDrillTileEntity) {
            ColumnPos cPos;
            SampleDrillTileEntity drill = (SampleDrillTileEntity)te;
            if (drill.isDummy()) {
                drill = (SampleDrillTileEntity)drill.master();
            }
            if (!drill.sample.func_190926_b() && (cPos = CoresampleItem.getCoords((ItemStack)drill.sample)) != null) {
                try {
                    World world = event.getWorld();
                    DimensionChunkCoords coords = new DimensionChunkCoords(world.func_234923_W_(), cPos.field_219439_a >> 4, cPos.field_219440_b >> 4);
                    ReservoirWorldInfo info = PumpjackHandler.getOrCreateOilWorldInfo(world, coords, false);
                    if (info != null && info.getType() != null) {
                        ItemNBTHelper.putString((ItemStack)drill.sample, (String)"resType", (String)info.getType().name);
                        ItemNBTHelper.putInt((ItemStack)drill.sample, (String)"resAmount", (int)info.current);
                    } else {
                        ItemNBTHelper.putInt((ItemStack)drill.sample, (String)"resAmount", (int)0);
                    }
                }
                catch (Exception e) {
                    ImmersivePetroleum.log.warn("This aint good!", (Throwable)e);
                }
            }
        }
    }

    @SubscribeEvent
    public void handleBoatImmunity(LivingAttackEvent event) {
        if (event.getSource() == DamageSource.field_76371_c || event.getSource() == DamageSource.field_76370_b || event.getSource() == DamageSource.field_76372_a) {
            LivingEntity entity = event.getEntityLiving();
            if (entity.func_184187_bx() instanceof MotorboatEntity) {
                MotorboatEntity boat = (MotorboatEntity)entity.func_184187_bx();
                if (boat.isFireproof) {
                    event.setCanceled(true);
                    return;
                }
            }
            if (entity.func_223314_ad() > 0 && entity.func_70660_b(IPEffects.ANTI_DISMOUNT_FIRE) != null) {
                entity.func_70066_B();
                entity.func_195063_d(IPEffects.ANTI_DISMOUNT_FIRE);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void handleBoatImmunity(TickEvent.PlayerTickEvent event) {
        PlayerEntity entity = event.player;
        if (entity.func_70027_ad() && entity.func_184187_bx() instanceof MotorboatEntity) {
            MotorboatEntity boat = (MotorboatEntity)entity.func_184187_bx();
            if (boat.isFireproof) {
                entity.func_70066_B();
                boat.func_70052_a(0, false);
            }
        }
    }

    @SubscribeEvent
    public void handleDismountingBoat(EntityMountEvent event) {
        if (event.getEntityMounting() == null) {
            return;
        }
        if (event.getEntityMounting() instanceof LivingEntity && event.getEntityBeingMounted() instanceof MotorboatEntity && event.isDismounting()) {
            FluidState fluidstate;
            MotorboatEntity boat = (MotorboatEntity)event.getEntityBeingMounted();
            if (boat.isFireproof && (fluidstate = event.getWorldObj().func_180495_p(new BlockPos(boat.func_213303_ch().func_72441_c(0.5, 0.0, 0.5))).func_204520_s()) != Fluids.field_204541_a.func_207188_f() && fluidstate.func_206884_a((ITag)FluidTags.field_206960_b)) {
                LivingEntity living = (LivingEntity)event.getEntityMounting();
                living.func_195064_c(new EffectInstance(IPEffects.ANTI_DISMOUNT_FIRE, 1, 0, false, false));
                return;
            }
        }
    }

    @SubscribeEvent
    public void handleLubricatingMachinesServer(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            CommonEventHandler.handleLubricatingMachines(event.world);
        }
    }

    public static void handleLubricatingMachines(World world) {
        HashSet<LubricatedHandler.LubricatedTileInfo> toRemove = new HashSet<LubricatedHandler.LubricatedTileInfo>();
        for (LubricatedHandler.LubricatedTileInfo info : LubricatedHandler.lubricatedTiles) {
            TileEntity te;
            LubricatedHandler.ILubricationHandler<TileEntity> lubeHandler;
            if (info.world != world.func_234923_W_() || !world.isAreaLoaded(info.pos, 0) || (lubeHandler = LubricatedHandler.getHandlerForTile(te = world.func_175625_s(info.pos))) == null) continue;
            if (lubeHandler.isMachineEnabled(world, te)) {
                if (world.field_72995_K) {
                    lubeHandler.lubricateClient((ClientWorld)world, info.lubricant, info.ticks, te);
                } else {
                    lubeHandler.lubricateServer((ServerWorld)world, info.lubricant, info.ticks, te);
                }
            }
            if (world.field_72995_K && te instanceof MultiblockPartTileEntity) {
                MultiblockPartTileEntity part = (MultiblockPartTileEntity)te;
                Vector3i size = lubeHandler.getStructureDimensions();
                int numBlocks = (int)((float)(size.func_177958_n() * size.func_177956_o() * size.func_177952_p()) * 0.25f);
                for (int i = 0; i < numBlocks; ++i) {
                    TileEntity te2;
                    BlockPos pos = part.getBlockPosForPos(new BlockPos((double)((float)size.func_177958_n() * random.nextFloat()), (double)((float)size.func_177956_o() * random.nextFloat()), (double)((float)size.func_177952_p() * random.nextFloat())));
                    if (world.func_180495_p(pos) == Blocks.field_150350_a.func_176223_P() || (te2 = world.func_175625_s(info.pos)) == null || !(te2 instanceof MultiblockPartTileEntity) || ((MultiblockPartTileEntity)te2).master() != part.master()) continue;
                    for (Direction facing : Direction.Plane.HORIZONTAL) {
                        if (world.field_73012_v.nextInt(30) != 0) continue;
                        Vector3i direction = facing.func_176730_m();
                        world.func_195594_a((IParticleData)ParticleTypes.field_229428_ah_, (double)((float)pos.func_177958_n() + 0.5f + (float)direction.func_177958_n() * 0.65f), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + 0.5f + (float)direction.func_177952_p() * 0.65f), 0.0, 0.0, 0.0);
                    }
                }
            }
            --info.ticks;
            if (info.ticks != 0) continue;
            toRemove.add(info);
        }
        for (LubricatedHandler.LubricatedTileInfo info : toRemove) {
            LubricatedHandler.lubricatedTiles.remove(info);
        }
    }

    @SubscribeEvent
    public void onEntityJoiningWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            if (event.getEntity() instanceof FakePlayer) {
                return;
            }
            if (((Boolean)IPServerConfig.MISCELLANEOUS.autounlock_recipes.get()).booleanValue()) {
                ArrayList l = new ArrayList();
                Collection recipes = event.getWorld().func_199532_z().func_199510_b();
                recipes.forEach(recipe -> {
                    ResourceLocation name = recipe.func_199560_c();
                    if (name.func_110624_b() == "immersivepetroleum" && recipe.func_77571_b().func_77973_b() != null) {
                        l.add(recipe);
                    }
                });
                ((PlayerEntity)event.getEntity()).func_195065_a(l);
            }
        }
    }

    @SubscribeEvent
    public void test(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void handleNapalm(TickEvent.WorldTickEvent event) {
        block5: {
            ResourceLocation d;
            block4: {
                d = event.world.func_234923_W_().getRegistryName();
                if (event.phase != TickEvent.Phase.START) break block4;
                toRemove.put(d, new ArrayList());
                if (napalmPositions.get(d) == null) break block5;
                ArrayList iterate = new ArrayList(napalmPositions.get(d));
                for (BlockPos position : iterate) {
                    BlockState state = event.world.func_180495_p(position);
                    if (state.func_177230_c() instanceof FlowingFluidBlock && state.func_177230_c() == IPContent.Fluids.napalm.block) {
                        ((NapalmFluid)IPContent.Fluids.napalm).processFire(event.world, position);
                    }
                    toRemove.get(d).add(position);
                }
                break block5;
            }
            if (event.phase == TickEvent.Phase.END && toRemove.get(d) != null && napalmPositions.get(d) != null) {
                for (BlockPos position : toRemove.get(d)) {
                    napalmPositions.get(d).remove(position);
                }
            }
        }
    }
}

