/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import flaxbeard.immersivepetroleum.client.model.ModelMotorboat;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MotorboatRenderer
extends EntityRenderer<MotorboatEntity> {
    private static ResourceLocation texture = ResourceUtils.ip("textures/models/boat_motor.png");
    private static ResourceLocation textureArmor = ResourceUtils.ip("textures/models/boat_motor_armor.png");
    public static final float DEG_TO_RAD = (float)Math.PI / 180;
    protected final ModelMotorboat modelBoat = new ModelMotorboat();

    public MotorboatRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.8f;
    }

    public void render(MotorboatEntity entity, float entityYaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer bufferIn, int packedLight) {
        float pr;
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, 0.375, 0.0);
        this.setupRotation(entity, entityYaw, partialTicks, matrix);
        this.modelBoat.setRotationAngles(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        if (entity.func_180799_ab()) {
            matrix.func_227861_a_(0.0, (double)-0.24375f, 0.0);
        }
        if (!entity.isEmergency()) {
            if (entity.isForwardDown()) {
                entity.propellerXRotSpeed = entity.propellerXRotSpeed + (entity.isBoosting ? 0.2f : 0.1f);
            }
            if (entity.isBackDown()) {
                entity.propellerXRotSpeed -= 0.2f;
            }
            entity.propellerXRot += entity.propellerXRotSpeed;
            entity.propellerXRot %= 360.0f;
        }
        entity.propellerXRotSpeed *= 0.985f;
        if (entity.propellerXRotSpeed != 0.0f && entity.propellerXRotSpeed >= -0.001f && entity.propellerXRotSpeed <= 0.001f) {
            entity.propellerXRotSpeed = 0.0f;
        }
        this.modelBoat.propeller.field_78795_f = entity.propellerXRot * ((float)Math.PI / 180);
        float f = pr = entity.isEmergency() ? 0.0f : entity.propellerYRotation;
        if (entity.isLeftInDown() && pr > -1.0f) {
            pr -= 0.1f * Minecraft.func_71410_x().func_184121_ak();
        }
        if (entity.isRightInDown() && pr < 1.0f) {
            pr += 0.1f * Minecraft.func_71410_x().func_184121_ak();
        }
        if (!entity.isLeftInDown() && !entity.isRightInDown()) {
            pr = (float)((double)pr * Math.pow(0.7, Minecraft.func_71410_x().func_184121_ak()));
        }
        this.modelBoat.propellerAssembly.field_78796_g = (float)Math.toRadians(pr * 15.0f);
        this.modelBoat.func_225598_a_(matrix, bufferIn.getBuffer(this.modelBoat.func_228282_a_(this.getEntityTexture(entity.isFireproof))), packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (entity.hasPaddles) {
            IVertexBuilder vbuilder_normal = bufferIn.getBuffer(this.modelBoat.func_228282_a_(texture));
            this.modelBoat.paddles[0].func_228308_a_(matrix, vbuilder_normal, packedLight, OverlayTexture.field_229196_a_);
            this.modelBoat.paddles[1].func_228308_a_(matrix, vbuilder_normal, packedLight, OverlayTexture.field_229196_a_);
        }
        IVertexBuilder vbuilder_armored = bufferIn.getBuffer(this.modelBoat.func_228282_a_(textureArmor));
        if (entity.hasIcebreaker) {
            this.modelBoat.icebreak.func_228308_a_(matrix, vbuilder_armored, packedLight, OverlayTexture.field_229196_a_);
        }
        if (entity.hasRudders) {
            this.modelBoat.ruddersBase.func_228308_a_(matrix, vbuilder_armored, packedLight, OverlayTexture.field_229196_a_);
            float pr2 = entity.propellerYRotation;
            if (entity.isLeftInDown() && pr2 > -1.0f) {
                pr2 -= 0.1f * Minecraft.func_71410_x().func_184121_ak();
            }
            if (entity.isRightInDown() && pr2 < 1.0f) {
                pr2 += 0.1f * Minecraft.func_71410_x().func_184121_ak();
            }
            if (!entity.isLeftInDown() && !entity.isRightInDown()) {
                pr2 = (float)((double)pr2 * Math.pow(0.7f, Minecraft.func_71410_x().func_184121_ak()));
            }
            this.modelBoat.rudder1.field_78796_g = (float)Math.toRadians(pr2 * 20.0f);
            this.modelBoat.rudder2.field_78796_g = (float)Math.toRadians(pr2 * 20.0f);
            this.modelBoat.rudder1.func_228308_a_(matrix, vbuilder_armored, packedLight, OverlayTexture.field_229196_a_);
            this.modelBoat.rudder2.func_228308_a_(matrix, vbuilder_armored, packedLight, OverlayTexture.field_229196_a_);
        }
        if (entity.hasTank) {
            this.modelBoat.tank.func_228308_a_(matrix, vbuilder_armored, packedLight, OverlayTexture.field_229196_a_);
        }
        if (!entity.func_204231_K()) {
            IVertexBuilder vbuilder_mask = bufferIn.getBuffer(RenderType.func_228651_i_());
            this.modelBoat.noWaterRenderer().func_228308_a_(matrix, vbuilder_mask, packedLight, OverlayTexture.field_229196_a_);
        }
        matrix.func_227865_b_();
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrix, bufferIn, packedLight);
    }

    public ResourceLocation getEntityTexture(MotorboatEntity entity) {
        return texture;
    }

    public ResourceLocation getEntityTexture(boolean armored) {
        return armored ? textureArmor : texture;
    }

    public void setupRotation(MotorboatEntity boat, float entityYaw, float partialTicks, MatrixStack matrix) {
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityYaw));
        float f = (float)boat.func_70268_h() - partialTicks;
        float f1 = boat.func_70271_g() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrix.func_227863_a_(new Quaternion(MathHelper.func_76126_a((float)f) * f * f1 / 10.0f * (float)boat.func_70267_i(), 0.0f, 0.0f, true));
        }
        if (boat.isBoosting) {
            matrix.func_227863_a_(new Quaternion(3.0f, 0.0f, 0.0f, true));
        }
        matrix.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
    }
}

