/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting.builders;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.tags.ITag;
import net.minecraft.util.Tuple;
import net.minecraftforge.fluids.FluidStack;

public class DistillationRecipeBuilder
extends IEFinishedRecipe<DistillationRecipeBuilder> {
    private List<Tuple<ItemStack, Double>> byproducts = new ArrayList<Tuple<ItemStack, Double>>();
    private static final DistillationRecipeBuilder dummy = new DistillationRecipeBuilder();

    public static DistillationRecipeBuilder builder(FluidStack ... fluidOutput) {
        if (fluidOutput == null || fluidOutput != null && fluidOutput.length == 0) {
            throw new IllegalArgumentException("Fluid output missing. It's required.");
        }
        DistillationRecipeBuilder b = new DistillationRecipeBuilder();
        if (fluidOutput != null && fluidOutput.length > 0) {
            b.addFluids("results", fluidOutput);
        }
        return b;
    }

    private DistillationRecipeBuilder() {
        super((IERecipeSerializer)Serializers.DISTILLATION_SERIALIZER.get());
        this.addWriter(jsonObject -> {
            if (this.byproducts.size() > 0) {
                JsonArray main = new JsonArray();
                this.byproducts.forEach(by -> main.add((JsonElement)DistillationRecipeBuilder.serializerItemStackWithChance((Tuple<ItemStack, Double>)by)));
                jsonObject.add("byproducts", (JsonElement)main);
                this.byproducts.clear();
            }
        });
    }

    public DistillationRecipeBuilder addByproduct(ItemStack byproduct, int chance) {
        return this.addByproduct(byproduct, (double)chance / 100.0);
    }

    public DistillationRecipeBuilder addByproduct(ItemStack byproduct, double chance) {
        this.byproducts.add((Tuple<ItemStack, Double>)new Tuple((Object)byproduct, (Object)Math.max(Math.min(chance, 1.0), 0.0)));
        return this;
    }

    public DistillationRecipeBuilder setTimeAndEnergy(int time, int energy) {
        return (DistillationRecipeBuilder)((DistillationRecipeBuilder)this.setTime(time)).setEnergy(energy);
    }

    public DistillationRecipeBuilder addInput(ITag.INamedTag<Fluid> fluidTag, int amount) {
        return (DistillationRecipeBuilder)this.addFluidTag("input", fluidTag, amount);
    }

    public DistillationRecipeBuilder addInput(Fluid fluid, int amount) {
        return this.addInput(new FluidStack(fluid, amount));
    }

    public DistillationRecipeBuilder addInput(FluidStack fluidStack) {
        return (DistillationRecipeBuilder)this.addFluid("input", fluidStack);
    }

    public DistillationRecipeBuilder addFluids(String key, FluidStack ... fluidStacks) {
        return (DistillationRecipeBuilder)this.addWriter(jsonObject -> {
            JsonArray array = new JsonArray();
            for (FluidStack stack : fluidStacks) {
                array.add(ApiUtils.jsonSerializeFluidStack((FluidStack)stack));
            }
            jsonObject.add(key, (JsonElement)array);
        });
    }

    public DistillationRecipeBuilder addItems(String key, ItemStack ... itemStacks) {
        return (DistillationRecipeBuilder)this.addWriter(jsonObject -> {
            JsonArray array = new JsonArray();
            for (ItemStack stack : itemStacks) {
                array.add((JsonElement)this.serializeItemStack(stack));
            }
            jsonObject.add(key, (JsonElement)array);
        });
    }

    public static Tuple<ItemStack, Double> deserializeItemStackWithChance(JsonObject jsonObject) {
        if (jsonObject.has("chance") && jsonObject.has("item")) {
            double chance = jsonObject.get("chance").getAsDouble();
            jsonObject.remove("chance");
            ItemStack stack = ShapedRecipe.func_199798_a((JsonObject)jsonObject);
            return new Tuple((Object)stack, (Object)chance);
        }
        throw new IllegalArgumentException("Unexpected json object.");
    }

    public static JsonObject serializerItemStackWithChance(@Nonnull Tuple<ItemStack, Double> tuple) {
        JsonObject itemJson = dummy.serializeItemStack((ItemStack)tuple.func_76341_a());
        itemJson.addProperty("chance", ((Double)tuple.func_76340_b()).toString());
        return itemJson;
    }
}

