/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.type;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.TextureType;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.texture.ctx.TextureContextCTM;
import team.chisel.ctm.client.texture.render.TextureEdges;
import team.chisel.ctm.client.texture.type.TextureTypeCTM;
import team.chisel.ctm.client.util.CTMLogic;
import team.chisel.ctm.client.util.Dir;

@TextureType(value="edges")
public class TextureTypeEdges
extends TextureTypeCTM {
    @Override
    public ICTMTexture<? extends TextureTypeCTM> makeTexture(TextureInfo info) {
        return new TextureEdges(this, info);
    }

    @Override
    public TextureContextCTM getBlockRenderContext(BlockState state, IBlockReader world, BlockPos pos, ICTMTexture<?> tex) {
        return new TextureContextCTM(state, world, pos, (TextureEdges)tex){

            @Override
            protected CTMLogic createCTM(BlockState state) {
                CTMLogic parent = super.createCTM(state);
                CTMLogicEdges ret = new CTMLogicEdges();
                ret.ignoreStates(parent.ignoreStates()).stateComparator(parent.stateComparator());
                ret.disableObscuredFaceCheck = parent.disableObscuredFaceCheck;
                return ret;
            }
        };
    }

    @Override
    public int requiredTextures() {
        return 3;
    }

    @ParametersAreNonnullByDefault
    public static class CTMLogicEdges
    extends CTMLogic {
        private boolean obscured;

        @Override
        public boolean isConnected(IBlockReader world, BlockPos current, BlockPos connection, Direction dir, BlockState state) {
            if (this.isObscured()) {
                return false;
            }
            BlockState obscuring = this.getConnectionState(world, current.func_177972_a(dir), dir, current);
            if (this.stateComparator(state, obscuring, dir)) {
                this.setObscured(true);
                return false;
            }
            BlockState con = this.getConnectionState(world, connection, dir, current);
            BlockState obscuringcon = this.getConnectionState(world, connection.func_177972_a(dir), dir, current);
            if (this.stateComparator(state, con, dir) || this.stateComparator(state, obscuringcon, dir)) {
                Vector3d difference = Vector3d.func_237491_b_((Vector3i)connection.func_177973_b((Vector3i)current));
                if (difference.func_189985_c() > 1.0) {
                    Vector3d vB;
                    Vector3d vA;
                    difference = difference.func_72432_b();
                    if (dir.func_176740_k() == Direction.Axis.Z) {
                        difference = difference.func_178785_b(-1.5707964f);
                    }
                    float ang = 0.7853982f;
                    if (dir.func_176740_k().func_200128_b()) {
                        vA = difference.func_178785_b(ang);
                        vB = difference.func_178785_b(-ang);
                    } else {
                        vA = difference.func_178789_a(ang);
                        vB = difference.func_178789_a(-ang);
                    }
                    BlockPos posA = new BlockPos(vA).func_177971_a((Vector3i)current);
                    BlockPos posB = new BlockPos(vB).func_177971_a((Vector3i)current);
                    return this.getConnectionState(world, posA, dir, current) == state && !this.stateComparator(state, this.getConnectionState(world, posA.func_177972_a(dir), dir, current), dir) || this.getConnectionState(world, posB, dir, current) == state && !this.stateComparator(state, this.getConnectionState(world, posB.func_177972_a(dir), dir, current), dir);
                }
                return true;
            }
            return false;
        }

        @Override
        protected void fillSubmaps(int idx) {
            Dir[] dirs = submapMap[idx];
            if (!this.connectedOr(dirs[0], dirs[1]) && this.connected(dirs[2])) {
                this.submapCache[idx] = submapOffsets[idx];
            } else {
                super.fillSubmaps(idx);
            }
        }

        @Override
        public long serialized() {
            return this.isObscured() ? super.serialized() | 0x100L : super.serialized();
        }

        public void setObscured(boolean obscured) {
            this.obscured = obscured;
        }

        public boolean isObscured() {
            return this.obscured;
        }
    }
}

