/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.instructions;

import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderElement;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.elements.AnimatedSceneElement;
import com.simibubi.create.foundation.ponder.instructions.TickingInstruction;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class FadeOutOfSceneInstruction<T extends AnimatedSceneElement>
extends TickingInstruction {
    private Direction fadeOutTo;
    private ElementLink<T> link;
    private T element;

    public FadeOutOfSceneInstruction(int fadeOutTicks, Direction fadeOutTo, ElementLink<T> link) {
        super(false, fadeOutTicks);
        this.fadeOutTo = fadeOutTo.func_176734_d();
        this.link = link;
    }

    @Override
    protected void firstTick(PonderScene scene) {
        super.firstTick(scene);
        this.element = (AnimatedSceneElement)scene.resolve(this.link);
        if (this.element == null) {
            return;
        }
        ((PonderElement)this.element).setVisible(true);
        ((AnimatedSceneElement)this.element).setFade(1.0f);
        ((AnimatedSceneElement)this.element).setFadeVec(Vector3d.func_237491_b_((Vector3i)this.fadeOutTo.func_176730_m()).func_186678_a(0.5));
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.element == null) {
            return;
        }
        float fade = (float)this.remainingTicks / (float)this.totalTicks;
        ((AnimatedSceneElement)this.element).setFade(1.0f - (1.0f - fade) * (1.0f - fade));
        if (this.remainingTicks == 0) {
            ((PonderElement)this.element).setVisible(false);
            ((AnimatedSceneElement)this.element).setFade(0.0f);
        }
    }
}

