/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorldParticles;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.elements.WorldSectionElement;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedClientWorld;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PonderWorld
extends SchematicWorld {
    public PonderScene scene;
    protected Map<BlockPos, BlockState> originalBlocks;
    protected Map<BlockPos, TileEntity> originalTileEntities;
    protected Map<BlockPos, Integer> blockBreakingProgressions;
    protected List<Entity> originalEntities;
    private LazyValue<ClientWorld> asClientWorld = new LazyValue(() -> WrappedClientWorld.of(this));
    protected PonderWorldParticles particles;
    private final Map<ResourceLocation, IParticleFactory<?>> particleFactories;
    int overrideLight;
    Selection mask;

    public PonderWorld(BlockPos anchor, World original) {
        super(anchor, original);
        this.originalBlocks = new HashMap<BlockPos, BlockState>();
        this.originalTileEntities = new HashMap<BlockPos, TileEntity>();
        this.blockBreakingProgressions = new HashMap<BlockPos, Integer>();
        this.originalEntities = new ArrayList<Entity>();
        this.particles = new PonderWorldParticles(this);
        this.particleFactories = (Map)ObfuscationReflectionHelper.getPrivateValue(ParticleManager.class, (Object)Minecraft.func_71410_x().field_71452_i, (String)"field_178932_g");
    }

    public void createBackup() {
        this.originalBlocks.clear();
        this.originalTileEntities.clear();
        this.blocks.forEach((k, v) -> this.originalBlocks.put((BlockPos)k, (BlockState)v));
        this.tileEntities.forEach((k, v) -> this.originalTileEntities.put((BlockPos)k, TileEntity.func_235657_b_((BlockState)((BlockState)this.blocks.get(k)), (CompoundNBT)v.func_189515_b(new CompoundNBT()))));
        this.entities.forEach(e -> EntityType.func_220330_a((CompoundNBT)e.serializeNBT(), (World)this).ifPresent(this.originalEntities::add));
    }

    public void restore() {
        this.entities.clear();
        this.blocks.clear();
        this.tileEntities.clear();
        this.blockBreakingProgressions.clear();
        this.renderedTileEntities.clear();
        this.originalBlocks.forEach((k, v) -> this.blocks.put(k, v));
        this.originalTileEntities.forEach((k, v) -> {
            TileEntity te = TileEntity.func_235657_b_((BlockState)this.originalBlocks.get(k), (CompoundNBT)v.func_189515_b(new CompoundNBT()));
            this.onTEadded(te, te.func_174877_v());
            this.tileEntities.put(k, te);
            this.renderedTileEntities.add(te);
        });
        this.originalEntities.forEach(e -> EntityType.func_220330_a((CompoundNBT)e.serializeNBT(), (World)this).ifPresent(this.entities::add));
        this.particles.clearEffects();
        this.fixControllerTileEntities();
    }

    public void restoreBlocks(Selection selection) {
        selection.forEach(p -> {
            if (this.originalBlocks.containsKey(p)) {
                this.blocks.put(p, this.originalBlocks.get(p));
            }
            if (this.originalTileEntities.containsKey(p)) {
                TileEntity te = TileEntity.func_235657_b_((BlockState)this.originalBlocks.get(p), (CompoundNBT)this.originalTileEntities.get(p).func_189515_b(new CompoundNBT()));
                this.onTEadded(te, te.func_174877_v());
                this.tileEntities.put(p, te);
            }
        });
        this.redraw();
    }

    private void redraw() {
        if (this.scene != null) {
            this.scene.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
        }
    }

    public void pushFakeLight(int light) {
        this.overrideLight = light;
    }

    public void popLight() {
        this.overrideLight = -1;
    }

    @Override
    public int func_226658_a_(LightType p_226658_1_, BlockPos p_226658_2_) {
        return this.overrideLight == -1 ? 15 : this.overrideLight;
    }

    public void setMask(Selection mask) {
        this.mask = mask;
    }

    public void clearMask() {
        this.mask = null;
    }

    @Override
    public BlockState func_180495_p(BlockPos globalPos) {
        if (this.mask != null && !this.mask.test(globalPos.func_177973_b((Vector3i)this.anchor))) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_180495_p(globalPos);
    }

    public IBlockReader func_225522_c_(int p_225522_1_, int p_225522_2_) {
        return this;
    }

    public void renderEntities(MatrixStack ms, SuperRenderTypeBuffer buffer, ActiveRenderInfo ari, float pt) {
        Vector3d Vector3d2 = ari.func_216785_c();
        double d0 = Vector3d2.func_82615_a();
        double d1 = Vector3d2.func_82617_b();
        double d2 = Vector3d2.func_82616_c();
        for (Entity entity : this.entities) {
            if (entity.field_70173_aa == 0) {
                entity.field_70142_S = entity.func_226277_ct_();
                entity.field_70137_T = entity.func_226278_cu_();
                entity.field_70136_U = entity.func_226281_cx_();
            }
            this.renderEntity(entity, d0, d1, d2, pt, ms, buffer);
        }
        buffer.draw(RenderType.func_228634_a_((ResourceLocation)PlayerContainer.field_226615_c_));
        buffer.draw(RenderType.func_228638_b_((ResourceLocation)PlayerContainer.field_226615_c_));
        buffer.draw(RenderType.func_228640_c_((ResourceLocation)PlayerContainer.field_226615_c_));
        buffer.draw(RenderType.func_228646_f_((ResourceLocation)PlayerContainer.field_226615_c_));
    }

    private void renderEntity(Entity entity, double x, double y, double z, float pt, MatrixStack ms, IRenderTypeBuffer buffer) {
        double d0 = MathHelper.func_219803_d((double)pt, (double)entity.field_70142_S, (double)entity.func_226277_ct_());
        double d1 = MathHelper.func_219803_d((double)pt, (double)entity.field_70137_T, (double)entity.func_226278_cu_());
        double d2 = MathHelper.func_219803_d((double)pt, (double)entity.field_70136_U, (double)entity.func_226281_cx_());
        float f = MathHelper.func_219799_g((float)pt, (float)entity.field_70126_B, (float)entity.field_70177_z);
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        int light = renderManager.func_78713_a(entity).func_229100_c_(entity, pt);
        renderManager.func_229084_a_(entity, d0 - x, d1 - y, d2 - z, f, pt, ms, buffer, light);
    }

    public void renderParticles(MatrixStack ms, IRenderTypeBuffer buffer, ActiveRenderInfo ari, float pt) {
        this.particles.renderParticles(ms, buffer, ari, pt);
    }

    public void tick() {
        this.particles.tick();
        Iterator iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            ++entity.field_70173_aa;
            entity.field_70142_S = entity.func_226277_ct_();
            entity.field_70137_T = entity.func_226278_cu_();
            entity.field_70136_U = entity.func_226281_cx_();
            entity.func_70071_h_();
            if (entity.func_226278_cu_() <= -0.5) {
                entity.func_70106_y();
            }
            if (entity.func_70089_S()) continue;
            iterator.remove();
        }
    }

    public void func_195594_a(IParticleData data, double x, double y, double z, double mx, double my, double mz) {
        this.addParticle(this.makeParticle(data, x, y, z, mx, my, mz));
    }

    public void func_195589_b(IParticleData data, double x, double y, double z, double mx, double my, double mz) {
        this.func_195594_a(data, x, y, z, mx, my, mz);
    }

    @Nullable
    private <T extends IParticleData> Particle makeParticle(T data, double x, double y, double z, double mx, double my, double mz) {
        ResourceLocation key = ForgeRegistries.PARTICLE_TYPES.getKey((IForgeRegistryEntry)data.func_197554_b());
        IParticleFactory<?> iparticlefactory = this.particleFactories.get(key);
        return iparticlefactory == null ? null : iparticlefactory.func_199234_a(data, (ClientWorld)this.asClientWorld.func_179281_c(), x, y, z, mx, my, mz);
    }

    @Override
    public boolean func_180501_a(BlockPos pos, BlockState arg1, int arg2) {
        return super.func_180501_a(pos, arg1, arg2);
    }

    public void addParticle(Particle p) {
        if (p != null) {
            this.particles.addParticle(p);
        }
    }

    @Override
    protected void onTEadded(TileEntity tileEntity, BlockPos pos) {
        super.onTEadded(tileEntity, pos);
        if (!(tileEntity instanceof SmartTileEntity)) {
            return;
        }
        SmartTileEntity smartTileEntity = (SmartTileEntity)tileEntity;
        smartTileEntity.markVirtual();
    }

    public void fixControllerTileEntities() {
        for (TileEntity tileEntity : this.tileEntities.values()) {
            if (tileEntity instanceof BeltTileEntity) {
                BeltTileEntity beltTileEntity = (BeltTileEntity)tileEntity;
                if (!beltTileEntity.isController()) continue;
                BlockPos controllerPos = tileEntity.func_174877_v();
                for (BlockPos blockPos : BeltBlock.getBeltChain(this, controllerPos)) {
                    TileEntity tileEntity2 = this.func_175625_s(blockPos);
                    if (!(tileEntity2 instanceof BeltTileEntity)) continue;
                    BeltTileEntity belt2 = (BeltTileEntity)tileEntity2;
                    belt2.setController(controllerPos);
                }
            }
            if (!(tileEntity instanceof FluidTankTileEntity)) continue;
            FluidTankTileEntity fluidTankTileEntity = (FluidTankTileEntity)tileEntity;
            BlockPos lastKnown = fluidTankTileEntity.getLastKnownPos();
            BlockPos current = fluidTankTileEntity.func_174877_v();
            if (lastKnown == null || current == null || fluidTankTileEntity.isController() || lastKnown.equals((Object)current)) continue;
            BlockPos newControllerPos = fluidTankTileEntity.getController().func_177971_a((Vector3i)current.func_177973_b((Vector3i)lastKnown));
            fluidTankTileEntity.setController(newControllerPos);
        }
    }

    public void setBlockBreakingProgress(BlockPos pos, int damage) {
        if (damage == 0) {
            this.blockBreakingProgressions.remove(pos);
        } else {
            this.blockBreakingProgressions.put(pos, damage - 1);
        }
    }

    public Map<BlockPos, Integer> getBlockBreakingProgressions() {
        return this.blockBreakingProgressions;
    }

    public void addBlockDestroyEffects(BlockPos pos, BlockState state) {
        VoxelShape voxelshape = state.func_196954_c((IBlockReader)this, pos);
        if (voxelshape.func_197766_b()) {
            return;
        }
        AxisAlignedBB bb = voxelshape.func_197752_a();
        double d1 = Math.min(1.0, bb.field_72336_d - bb.field_72340_a);
        double d2 = Math.min(1.0, bb.field_72337_e - bb.field_72338_b);
        double d3 = Math.min(1.0, bb.field_72334_f - bb.field_72339_c);
        int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.25)));
        int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.25)));
        int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.25)));
        for (int l = 0; l < i; ++l) {
            for (int i1 = 0; i1 < j; ++i1) {
                for (int j1 = 0; j1 < k; ++j1) {
                    double d4 = ((double)l + 0.5) / (double)i;
                    double d5 = ((double)i1 + 0.5) / (double)j;
                    double d6 = ((double)j1 + 0.5) / (double)k;
                    double d7 = d4 * d1 + bb.field_72340_a;
                    double d8 = d5 * d2 + bb.field_72338_b;
                    double d9 = d6 * d3 + bb.field_72339_c;
                    this.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), (double)pos.func_177958_n() + d7, (double)pos.func_177956_o() + d8, (double)pos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5);
                }
            }
        }
    }

    @Override
    protected BlockState processBlockStateForPrinting(BlockState state) {
        return state;
    }

    @Override
    public boolean func_175667_e(BlockPos pos) {
        return true;
    }

    public boolean func_217354_b(int x, int y) {
        return true;
    }

    public boolean func_195588_v(BlockPos pos) {
        return true;
    }

    public boolean func_217358_a(double p_217358_1_, double p_217358_3_, double p_217358_5_, double p_217358_7_) {
        return true;
    }
}

